/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Vote
extends MultipleClassifiersCombiner
implements TechnicalInformationHandler {
    static final long serialVersionUID = -637891196294399624L;
    public static final int AVERAGE_RULE = 1;
    public static final int PRODUCT_RULE = 2;
    public static final int MAJORITY_VOTING_RULE = 3;
    public static final int MIN_RULE = 4;
    public static final int MAX_RULE = 5;
    public static final int MEDIAN_RULE = 6;
    public static final Tag[] TAGS_RULES = new Tag[]{new Tag(1, "AVG", "Average of Probabilities"), new Tag(2, "PROD", "Product of Probabilities"), new Tag(3, "MAJ", "Majority Voting"), new Tag(4, "MIN", "Minimum Probability"), new Tag(5, "MAX", "Maximum Probability"), new Tag(6, "MED", "Median")};
    protected int m_CombinationRule = 1;

    public String globalInfo() {
        return "Class for combining classifiers. Different combinations of probability estimates for classification are available.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "R", 1, "-R " + Tag.toOptionList(TAGS_RULES)));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-R");
        vector.add("" + this.getCombinationRule());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setCombinationRule(new SelectedTag(string, TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, TAGS_RULES));
        }
        super.setOptions(stringArray);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ludmila I. Kuncheva");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Combining Pattern Classifiers: Methods and Algorithms");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons, Inc.");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "J. Kittler and M. Hatef and Robert P.W. Duin and J. Matas");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "On combining classifiers");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "20");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "3");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "226-239");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        if (this.m_CombinationRule == 2 || this.m_CombinationRule == 3) {
            capabilities.disableAllClasses();
            capabilities.disableAllClassDependencies();
            capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
            capabilities.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        } else if (this.m_CombinationRule == 6) {
            capabilities.disableAllClasses();
            capabilities.disableAllClassDependencies();
            capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
            capabilities.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        }
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.getClassifier(i).buildClassifier(instances2);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d;
        switch (this.m_CombinationRule) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                d = Utils.maxIndex(this.distributionForInstance(instance));
                if (d != 0.0) break;
                d = Instance.missingValue();
                break;
            }
            case 6: {
                d = this.classifyInstanceMedian(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        return d;
    }

    protected double classifyInstanceMedian(Instance instance) throws Exception {
        double[] dArray = new double[this.m_Classifiers.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.m_Classifiers[i].classifyInstance(instance);
        }
        double d = dArray.length == 0 ? 0.0 : (dArray.length == 1 ? dArray[0] : Utils.kthSmallestValue(dArray, dArray.length / 2));
        return d;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        switch (this.m_CombinationRule) {
            case 1: {
                dArray = this.distributionForInstanceAverage(instance);
                break;
            }
            case 2: {
                dArray = this.distributionForInstanceProduct(instance);
                break;
            }
            case 3: {
                dArray = this.distributionForInstanceMajorityVoting(instance);
                break;
            }
            case 4: {
                dArray = this.distributionForInstanceMin(instance);
                break;
            }
            case 5: {
                dArray = this.distributionForInstanceMax(instance);
                break;
            }
            case 6: {
                dArray[0] = this.classifyInstance(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        if (!instance.classAttribute().isNumeric()) {
            Utils.normalize(dArray);
        }
        return dArray;
    }

    protected double[] distributionForInstanceAverage(Instance instance) throws Exception {
        int n;
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        for (n = 1; n < this.m_Classifiers.length; ++n) {
            double[] dArray2 = this.getClassifier(n).distributionForInstance(instance);
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
        }
        n = 0;
        while (n < dArray.length) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)this.m_Classifiers.length;
        }
        return dArray;
    }

    protected double[] distributionForInstanceProduct(Instance instance) throws Exception {
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dArray2 = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] * dArray2[j];
            }
        }
        return dArray;
    }

    protected double[] distributionForInstanceMajorityVoting(Instance instance) throws Exception {
        int n;
        int n2;
        int n3;
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        double[] dArray2 = new double[dArray.length];
        for (n3 = 0; n3 < this.m_Classifiers.length; ++n3) {
            dArray = this.getClassifier(n3).distributionForInstance(instance);
            n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                if (!(dArray[n] > dArray[n2])) continue;
                n2 = n;
            }
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] != dArray[n2]) continue;
                int n4 = n;
                dArray2[n4] = dArray2[n4] + 1.0;
            }
        }
        n3 = 0;
        for (n2 = 1; n2 < dArray2.length; ++n2) {
            if (!(dArray2[n2] > dArray2[n3])) continue;
            n3 = n2;
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < dArray2.length; ++n) {
            if (dArray2[n] != dArray2[n3]) continue;
            vector.add(new Integer(n));
        }
        n = (Integer)vector.get((int)(Math.random() / (double)(1 / vector.size())));
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        dArray[n] = 1.0;
        return dArray;
    }

    protected double[] distributionForInstanceMax(Instance instance) throws Exception {
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dArray2 = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                if (!(dArray[j] < dArray2[j])) continue;
                dArray[j] = dArray2[j];
            }
        }
        return dArray;
    }

    protected double[] distributionForInstanceMin(Instance instance) throws Exception {
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        for (int i = 1; i < this.m_Classifiers.length; ++i) {
            double[] dArray2 = this.getClassifier(i).distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                if (!(dArray2[j] < dArray[j])) continue;
                dArray[j] = dArray2[j];
            }
        }
        return dArray;
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, TAGS_RULES);
    }

    public void setCombinationRule(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_RULES) {
            this.m_CombinationRule = selectedTag.getSelectedTag().getID();
        }
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Vote: No model built yet.";
        }
        String string = "Vote combines";
        string = string + " the probability distributions of these base learners:\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            string = string + '\t' + this.getClassifierSpec(i) + '\n';
        }
        string = string + "using the '";
        switch (this.m_CombinationRule) {
            case 1: {
                string = string + "Average of Probabilities";
                break;
            }
            case 2: {
                string = string + "Product of Probabilities";
                break;
            }
            case 3: {
                string = string + "Majority Voting";
                break;
            }
            case 4: {
                string = string + "Minimum Probability";
                break;
            }
            case 5: {
                string = string + "Maximum Probability";
                break;
            }
            case 6: {
                string = string + "Median Probability";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        string = string + "' combination rule \n";
        return string;
    }

    public static void main(String[] stringArray) {
        Vote.runClassifier(new Vote(), stringArray);
    }
}

