/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveUseless
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -8659417851407640038L;
    protected Remove m_removeFilter = null;
    protected double m_maxVariancePercentage = 99.0;

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_removeFilter = null;
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_removeFilter != null) {
            this.m_removeFilter.input(instance);
            Instance instance2 = this.m_removeFilter.output();
            instance2.setDataset(this.getOutputFormat());
            this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
            this.push(instance2);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_removeFilter == null) {
            Instance instance;
            Instances instances = this.getInputFormat();
            int[] nArray = new int[instances.numAttributes()];
            int n = 0;
            for (int i = 0; i < instances.numAttributes(); ++i) {
                double d;
                if (i == instances.classIndex()) continue;
                AttributeStats attributeStats = instances.attributeStats(i);
                if (attributeStats.distinctCount < 2) {
                    nArray[n++] = i;
                    continue;
                }
                if (!instances.attribute(i).isNominal() || !((d = (double)attributeStats.distinctCount / (double)(attributeStats.totalCount - attributeStats.missingCount) * 100.0) > this.m_maxVariancePercentage)) continue;
                nArray[n++] = i;
            }
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            this.m_removeFilter = new Remove();
            this.m_removeFilter.setAttributeIndicesArray(nArray2);
            this.m_removeFilter.setInvertSelection(false);
            this.m_removeFilter.setInputFormat(instances);
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.m_removeFilter.input(instances.instance(i));
            }
            this.m_removeFilter.batchFinished();
            Instances instances2 = this.m_removeFilter.getOutputFormat();
            instances2.setRelationName(instances.relationName());
            this.setOutputFormat(instances2);
            while ((instance = this.m_removeFilter.output()) != null) {
                instance.setDataset(instances2);
                this.push(instance);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tMaximum variance percentage allowed (default 99)", "M", 1, "-M <max variance %>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMaximumVariancePercentageAllowed((int)Double.valueOf(string).doubleValue());
        } else {
            this.setMaximumVariancePercentageAllowed(99.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMaximumVariancePercentageAllowed();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "This filter removes attributes that do not vary at all or that vary too much. All constant attributes are deleted automatically, along with any that exceed the maximum percentage of variance parameter. The maximum variance test is only applied to nominal attributes.";
    }

    public String maximumVariancePercentageAllowedTipText() {
        return "Set the threshold for the highest variance allowed before a nominal attribute will be deleted.Specifically, if (number_of_distinct_values / total_number_of_values * 100) is greater than this value then the attribute will be removed.";
    }

    public void setMaximumVariancePercentageAllowed(double d) {
        this.m_maxVariancePercentage = d;
    }

    public double getMaximumVariancePercentageAllowed() {
        return this.m_maxVariancePercentage;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.12 $");
    }

    public static void main(String[] stringArray) {
        RemoveUseless.runFilter(new RemoveUseless(), stringArray);
    }
}

