/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.parser.JFlex.Action;
import weka.core.parser.JFlex.CharClassInterval;
import weka.core.parser.JFlex.CharClasses;
import weka.core.parser.JFlex.CharSet;
import weka.core.parser.JFlex.CharSetEnumerator;
import weka.core.parser.JFlex.CountEmitter;
import weka.core.parser.JFlex.DFA;
import weka.core.parser.JFlex.EOFActions;
import weka.core.parser.JFlex.HiLowEmitter;
import weka.core.parser.JFlex.LexParse;
import weka.core.parser.JFlex.LexScan;
import weka.core.parser.JFlex.Options;
import weka.core.parser.JFlex.Out;
import weka.core.parser.JFlex.Skeleton;

public final class Emitter {
    private static final int FINAL = 1;
    private static final int PUSHBACK = 2;
    private static final int LOOKEND = 4;
    private static final int NOLOOK = 8;
    private static final String date = new SimpleDateFormat().format(new Date());
    private File inputFile;
    private PrintWriter out;
    private Skeleton skel;
    private LexScan scanner;
    private LexParse parser;
    private DFA dfa;
    private CharSet[][] table;
    private boolean[] isTransition;
    private CharSet[] noTarget;
    private int numRows;
    private int[] rowMap;
    private boolean[] rowKilled;
    private int numCols;
    private int[] colMap;
    private boolean[] colKilled;
    private Hashtable actionTable = new Hashtable();
    private CharClassInterval[] intervalls;
    private String visibility = "public";

    public Emitter(File file, LexParse lexParse, DFA dFA) throws IOException {
        String string = lexParse.scanner.className + ".java";
        File file2 = Emitter.normalize(string, file);
        Out.println("Writing code to \"" + file2 + "\"");
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
        this.parser = lexParse;
        this.scanner = lexParse.scanner;
        this.visibility = this.scanner.visibility;
        this.inputFile = file;
        this.dfa = dFA;
        this.skel = new Skeleton(this.out);
    }

    public static File normalize(String string, File file) {
        File file2 = Options.getDir() == null ? (file == null || file.getParent() == null ? new File(string) : new File(file.getParent(), string)) : new File(Options.getDir(), string);
        if (file2.exists() && !Options.no_backup) {
            File file3 = new File(file2.toString() + "~");
            if (file3.exists()) {
                file3.delete();
            }
            if (file2.renameTo(file3)) {
                Out.println("Old file \"" + file2 + "\" saved as \"" + file3 + "\"");
            } else {
                Out.println("Couldn't save old file \"" + file2 + "\", overwriting!");
            }
        }
        return file2;
    }

    private void println() {
        this.out.println();
    }

    private void println(String string) {
        this.out.println(string);
    }

    private void println(int n) {
        this.out.println(n);
    }

    private void print(String string) {
        this.out.print(string);
    }

    private void print(int n) {
        this.out.print(n);
    }

    private void print(int n, int n2) {
        int n3 = n < 0 ? 1 : 10;
        while (n2-- > 1) {
            if (Math.abs(n) < n3) {
                this.print(" ");
            }
            n3 *= 10;
        }
        this.print(n);
    }

    private void emitScanError() {
        this.print("  private void zzScanError(int errorCode)");
        if (this.scanner.scanErrorException != null) {
            this.print(" throws " + this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException == null) {
            this.println("    throw new Error(message);");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException + "(message);");
        }
        this.skel.emitNext();
        this.print("  " + this.visibility + " void yypushback(int number) ");
        if (this.scanner.scanErrorException == null) {
            this.println(" {");
        } else {
            this.println(" throws " + this.scanner.scanErrorException + " {");
        }
    }

    private void emitMain() {
        if (!(this.scanner.standalone || this.scanner.debugOption || this.scanner.cupDebug)) {
            return;
        }
        if (this.scanner.cupDebug) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol);
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            this.println("  private String getTokenName(int token) {");
            this.println("    try {");
            this.println("      java.lang.reflect.Field [] classFields = " + this.scanner.cupSymbol + ".class.getFields();");
            this.println("      for (int i = 0; i < classFields.length; i++) {");
            this.println("        if (classFields[i].getInt(null) == token) {");
            this.println("          return classFields[i].getName();");
            this.println("        }");
            this.println("      }");
            this.println("    } catch (Exception e) {");
            this.println("      e.printStackTrace(System.err);");
            this.println("    }");
            this.println("");
            this.println("    return \"UNKNOWN TOKEN\";");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + this.scanner.functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            this.print("  " + this.visibility + " ");
            if (this.scanner.tokenType == null) {
                if (this.scanner.isInteger) {
                    this.print("int");
                } else if (this.scanner.isIntWrap) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType);
            }
            this.print(" debug_");
            this.print(this.scanner.functionName);
            this.print("() throws java.io.IOException");
            if (this.scanner.lexThrow != null) {
                this.print(", ");
                this.print(this.scanner.lexThrow);
            }
            if (this.scanner.scanErrorException != null) {
                this.print(", ");
                this.print(this.scanner.scanErrorException);
            }
            this.println(" {");
            this.println("    java_cup.runtime.Symbol s = " + this.scanner.functionName + "();");
            this.print("    System.out.println( ");
            if (this.scanner.lineCount) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s.sym) + \"--\");");
            this.println("    return s;");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        this.println("  public static void main(String argv[]) {");
        this.println("    if (argv.length == 0) {");
        this.println("      System.out.println(\"Usage : java " + this.scanner.className + " <inputfile>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      for (int i = 0; i < argv.length; i++) {");
        this.println("        " + this.scanner.className + " scanner = null;");
        this.println("        try {");
        this.println("          scanner = new " + this.scanner.className + "( new java.io.FileReader(argv[i]) );");
        if (this.scanner.standalone) {
            this.println("          while ( !scanner.zzAtEOF ) scanner." + this.scanner.functionName + "();");
        } else if (this.scanner.cupDebug) {
            this.println("          while ( !scanner.zzAtEOF ) scanner.debug_" + this.scanner.functionName + "();");
        } else {
            this.println("          do {");
            this.println("            System.out.println(scanner." + this.scanner.functionName + "());");
            this.println("          } while (!scanner.zzAtEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch (java.io.FileNotFoundException e) {");
        this.println("          System.out.println(\"File not found : \\\"\"+argv[i]+\"\\\"\");");
        this.println("        }");
        this.println("        catch (java.io.IOException e) {");
        this.println("          System.out.println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\");");
        this.println("          System.out.println(e);");
        this.println("        }");
        this.println("        catch (Exception e) {");
        this.println("          System.out.println(\"Unexpected exception:\");");
        this.println("          e.printStackTrace();");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    private void emitNoMatch() {
        this.println("            zzScanError(ZZ_NO_MATCH);");
    }

    private void emitNextInput() {
        this.println("          if (zzCurrentPosL < zzEndReadL)");
        this.println("            zzInput = zzBufferL[zzCurrentPosL++];");
        this.println("          else if (zzAtEOF) {");
        this.println("            zzInput = YYEOF;");
        this.println("            break zzForAction;");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            zzCurrentPos  = zzCurrentPosL;");
        this.println("            zzMarkedPos   = zzMarkedPosL;");
        if (this.scanner.lookAheadUsed) {
            this.println("            zzPushbackPos = zzPushbackPosL;");
        }
        this.println("            boolean eof = zzRefill();");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            zzCurrentPosL  = zzCurrentPos;");
        this.println("            zzMarkedPosL   = zzMarkedPos;");
        this.println("            zzBufferL      = zzBuffer;");
        this.println("            zzEndReadL     = zzEndRead;");
        if (this.scanner.lookAheadUsed) {
            this.println("            zzPushbackPosL = zzPushbackPos;");
        }
        this.println("            if (eof) {");
        this.println("              zzInput = YYEOF;");
        this.println("              break zzForAction;");
        this.println("            }");
        this.println("            else {");
        this.println("              zzInput = zzBufferL[zzCurrentPosL++];");
        this.println("            }");
        this.println("          }");
    }

    private void emitHeader() {
        this.println("/* The following code was generated by JFlex 1.4.1 on " + date + " */");
        this.println("");
    }

    private void emitUserCode() {
        if (this.scanner.userCode.length() > 0) {
            this.println(this.scanner.userCode.toString());
        }
    }

    private void emitClassName() {
        if (!Emitter.endsWithJavadoc(this.scanner.userCode)) {
            String string = this.inputFile.toString();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            this.println("/**");
            this.println(" * This class is a scanner generated by ");
            this.println(" * <a href=\"http://www.jflex.de/\">JFlex</a> 1.4.1");
            this.println(" * on " + date + " from the specification file");
            this.println(" * <tt>" + string + "</tt>");
            this.println(" */");
        }
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        if (this.scanner.isAbstract) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className);
        if (this.scanner.isExtending != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending);
        }
        if (this.scanner.isImplementing != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing);
        }
        this.println(" {");
    }

    public static boolean endsWithJavadoc(StringBuffer stringBuffer) {
        String string = stringBuffer.toString().trim();
        if (!string.endsWith("*/")) {
            return false;
        }
        int n = string.lastIndexOf("/**");
        if (n < 0) {
            return false;
        }
        return string.substring(n, string.length() - 2).indexOf("*/") < 0;
    }

    private void emitLexicalStates() {
        int n;
        Enumeration enumeration = this.scanner.states.names();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n = this.scanner.states.getNumber(string);
            if (this.scanner.bolUsed) {
                this.println("  " + this.visibility + " static final int " + string + " = " + 2 * n + ";");
                continue;
            }
            this.println("  " + this.visibility + " static final int " + string + " = " + this.dfa.lexState[2 * n] + ";");
        }
        if (this.scanner.bolUsed) {
            int n2;
            this.println("");
            this.println("  /**");
            this.println("   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l");
            this.println("   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l");
            this.println("   *                  at the beginning of a line");
            this.println("   * l is of the form l = 2*k, k a non negative integer");
            this.println("   */");
            this.println("  private static final int ZZ_LEXSTATE[] = { ");
            n = 0;
            this.print("    ");
            for (n2 = 0; n2 < this.dfa.lexState.length - 1; ++n2) {
                this.print(this.dfa.lexState[n2], 2);
                this.print(", ");
                if (++n < 16) continue;
                this.println();
                this.print("    ");
                n = 0;
            }
            this.println(this.dfa.lexState[n2]);
            this.println("  };");
        }
    }

    private void emitDynamicInit() {
        int n = 0;
        int n2 = this.dfa.table[0][0];
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        CountEmitter countEmitter = new CountEmitter("Trans");
        countEmitter.setValTranslation(1);
        countEmitter.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (this.rowKilled[i]) continue;
            for (int j = 0; j < this.dfa.numInput; ++j) {
                if (this.colKilled[j]) continue;
                if (this.dfa.table[i][j] == n2) {
                    ++n;
                    continue;
                }
                countEmitter.emit(n, n2);
                n = 1;
                n2 = this.dfa.table[i][j];
            }
        }
        countEmitter.emit(n, n2);
        countEmitter.emitUnpack();
        this.println(countEmitter.toString());
    }

    private void emitCharMapInitFunction() {
        CharClasses charClasses = this.parser.getCharClasses();
        if (charClasses.getMaxCharCode() < '\u0100') {
            return;
        }
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed character translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed character translation table");
        this.println("   * @return         the unpacked character translation table");
        this.println("   */");
        this.println("  private static char [] zzUnpackCMap(String packed) {");
        this.println("    char [] map = new char[0x10000];");
        this.println("    int i = 0;  /* index in packed string  */");
        this.println("    int j = 0;  /* index in unpacked array */");
        this.println("    while (i < " + 2 * this.intervalls.length + ") {");
        this.println("      int  count = packed.charAt(i++);");
        this.println("      char value = packed.charAt(i++);");
        this.println("      do map[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return map;");
        this.println("  }");
    }

    private void emitZZTrans() {
        int n = 0;
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        this.println("  private static final int ZZ_TRANS [] = {");
        this.print("    ");
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (this.rowKilled[i]) continue;
            for (int j = 0; j < this.dfa.numInput; ++j) {
                if (this.colKilled[j]) continue;
                if (n >= 10) {
                    this.println();
                    this.print("    ");
                    n = 0;
                }
                this.print(this.dfa.table[i][j]);
                if (i != this.dfa.numStates - 1 || j != this.dfa.numInput - 1) {
                    this.print(", ");
                }
                ++n;
            }
        }
        this.println();
        this.println("  };");
    }

    private void emitCharMapArrayUnPacked() {
        CharClasses charClasses = this.parser.getCharClasses();
        this.intervalls = charClasses.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] ZZ_CMAP = {");
        int n = 0;
        this.print("    ");
        char c = charClasses.getMaxCharCode();
        for (int i = 0; i < this.intervalls.length && this.intervalls[i].start <= c; ++i) {
            int n2 = Math.min(this.intervalls[i].end, c);
            for (int j = this.intervalls[i].start; j <= n2; ++j) {
                this.print(this.colMap[this.intervalls[i].charClass], 2);
                if (j >= c) continue;
                this.print(", ");
                if (++n < 16) continue;
                this.println();
                this.print("    ");
                n = 0;
            }
        }
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitCharMapArray() {
        int n;
        CharClasses charClasses = this.parser.getCharClasses();
        if (charClasses.getMaxCharCode() < '\u0100') {
            this.emitCharMapArrayUnPacked();
            return;
        }
        this.intervalls = charClasses.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final String ZZ_CMAP_PACKED = ");
        int n2 = 0;
        this.print("    \"");
        for (n = 0; n < this.intervalls.length - 1; ++n) {
            int n3 = this.intervalls[n].end - this.intervalls[n].start + 1;
            int n4 = this.colMap[this.intervalls[n].charClass];
            this.printUC(n3);
            this.printUC(n4);
            if (++n2 < 10) continue;
            this.println("\"+");
            this.print("    \"");
            n2 = 0;
        }
        this.printUC(this.intervalls[n].end - this.intervalls[n].start + 1);
        this.printUC(this.colMap[this.intervalls[n].charClass]);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);");
        this.println();
    }

    private void printUC(int n) {
        if (n > 255) {
            this.out.print("\\u");
            if (n < 4096) {
                this.out.print("0");
            }
            this.out.print(Integer.toHexString(n));
        } else {
            this.out.print("\\");
            this.out.print(Integer.toOctalString(n));
        }
    }

    private void emitRowMapArray() {
        this.println("");
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        HiLowEmitter hiLowEmitter = new HiLowEmitter("RowMap");
        hiLowEmitter.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            hiLowEmitter.emit(this.rowMap[i] * this.numCols);
        }
        hiLowEmitter.emitUnpack();
        this.println(hiLowEmitter.toString());
    }

    private void emitAttributes() {
        this.println("  /**");
        this.println("   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>");
        this.println("   */");
        CountEmitter countEmitter = new CountEmitter("Attribute");
        countEmitter.emitInit();
        int n = 1;
        int n2 = 0;
        if (this.dfa.isFinal[0]) {
            n2 = 1;
        }
        if (this.dfa.isPushback[0]) {
            n2 |= 2;
        }
        if (this.dfa.isLookEnd[0]) {
            n2 |= 4;
        }
        if (!this.isTransition[0]) {
            n2 |= 8;
        }
        for (int i = 1; i < this.dfa.numStates; ++i) {
            int n3 = 0;
            if (this.dfa.isFinal[i]) {
                n3 = 1;
            }
            if (this.dfa.isPushback[i]) {
                n3 |= 2;
            }
            if (this.dfa.isLookEnd[i]) {
                n3 |= 4;
            }
            if (!this.isTransition[i]) {
                n3 |= 8;
            }
            if (n2 == n3) {
                ++n;
                continue;
            }
            countEmitter.emit(n, n2);
            n = 1;
            n2 = n3;
        }
        countEmitter.emit(n, n2);
        countEmitter.emitUnpack();
        this.println(countEmitter.toString());
    }

    private void emitClassCode() {
        if (this.scanner.eofCode != null) {
            this.println("  /** denotes if the user-EOF-code has already been executed */");
            this.println("  private boolean zzEOFDone;");
            this.println("");
        }
        if (this.scanner.classCode != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode);
        }
    }

    private void emitConstructorDecl() {
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.Reader in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        if (this.scanner.initCode != null) {
            this.print("  ");
            this.print(this.scanner.initCode);
        }
        this.println("    this.zzReader = in;");
        this.println("  }");
        this.println();
        this.println("  /**");
        this.println("   * Creates a new scanner.");
        this.println("   * There is also java.io.Reader version of this constructor.");
        this.println("   *");
        this.println("   * @param   in  the java.io.Inputstream to read input from.");
        this.println("   */");
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.InputStream in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        this.println("    this(new java.io.InputStreamReader(in));");
        this.println("  }");
    }

    private void emitDoEOF() {
        if (this.scanner.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        this.print("  private void zzDoEOF()");
        if (this.scanner.eofThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.eofThrow);
        }
        this.println(" {");
        this.println("    if (!zzEOFDone) {");
        this.println("      zzEOFDone = true;");
        this.println("    " + this.scanner.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    private void emitLexFunctHeader() {
        if (this.scanner.cupCompatible) {
            this.print("  public ");
        } else {
            this.print("  " + this.visibility + " ");
        }
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.print(" ");
        this.print(this.scanner.functionName);
        this.print("() throws java.io.IOException");
        if (this.scanner.lexThrow != null) {
            this.print(", ");
            this.print(this.scanner.lexThrow);
        }
        if (this.scanner.scanErrorException != null) {
            this.print(", ");
            this.print(this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.println("    int [] zzTransL = ZZ_TRANS;");
            this.println("    int [] zzRowMapL = ZZ_ROWMAP;");
            this.println("    int [] zzAttrL = ZZ_ATTRIBUTE;");
        }
        if (this.scanner.lookAheadUsed) {
            this.println("    int zzPushbackPosL = zzPushbackPos = -1;");
            this.println("    boolean zzWasPushback;");
        }
        this.skel.emitNext();
        if (this.scanner.charCount) {
            this.println("      yychar+= zzMarkedPosL-zzStartRead;");
            this.println("");
        }
        if (this.scanner.lineCount || this.scanner.columnCount) {
            this.println("      boolean zzR = false;");
            this.println("      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;");
            this.println("                                                             zzCurrentPosL++) {");
            this.println("        switch (zzBufferL[zzCurrentPosL]) {");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = false;");
            this.println("          break;");
            this.println("        case '\\r':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = true;");
            this.println("          break;");
            this.println("        case '\\n':");
            this.println("          if (zzR)");
            this.println("            zzR = false;");
            this.println("          else {");
            if (this.scanner.lineCount) {
                this.println("            yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("            yycolumn = 0;");
            }
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzR = false;");
            if (this.scanner.columnCount) {
                this.println("          yycolumn++;");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount) {
                this.println("      if (zzR) {");
                this.println("        // peek one character ahead if it is \\n (if we have counted one line too much)");
                this.println("        boolean zzPeek;");
                this.println("        if (zzMarkedPosL < zzEndReadL)");
                this.println("          zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        else if (zzAtEOF)");
                this.println("          zzPeek = false;");
                this.println("        else {");
                this.println("          boolean eof = zzRefill();");
                this.println("          zzEndReadL = zzEndRead;");
                this.println("          zzMarkedPosL = zzMarkedPos;");
                this.println("          zzBufferL = zzBuffer;");
                this.println("          if (eof) ");
                this.println("            zzPeek = false;");
                this.println("          else ");
                this.println("            zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        }");
                this.println("        if (zzPeek) yyline--;");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed) {
            this.println("      if (zzMarkedPosL > zzStartRead) {");
            this.println("        switch (zzBufferL[zzMarkedPosL-1]) {");
            this.println("        case '\\n':");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            this.println("          zzAtBOL = true;");
            this.println("          break;");
            this.println("        case '\\r': ");
            this.println("          if (zzMarkedPosL < zzEndReadL)");
            this.println("            zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          else if (zzAtEOF)");
            this.println("            zzAtBOL = false;");
            this.println("          else {");
            this.println("            boolean eof = zzRefill();");
            this.println("            zzMarkedPosL = zzMarkedPos;");
            this.println("            zzEndReadL = zzEndRead;");
            this.println("            zzBufferL = zzBuffer;");
            this.println("            if (eof) ");
            this.println("              zzAtBOL = false;");
            this.println("            else ");
            this.println("              zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzAtBOL = false;");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed) {
            this.println("      if (zzAtBOL)");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState+1];");
            this.println("      else");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState];");
            this.println();
        } else {
            this.println("      zzState = zzLexicalState;");
            this.println();
        }
        if (this.scanner.lookAheadUsed) {
            this.println("      zzWasPushback = false;");
        }
        this.skel.emitNext();
    }

    private void emitGetRowMapNext() {
        this.println("          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];");
        this.println("          if (zzNext == -1) break zzForAction;");
        this.println("          zzState = zzNext;");
        this.println();
        this.println("          int zzAttributes = zzAttrL[zzState];");
        if (this.scanner.lookAheadUsed) {
            this.println("          if ( (zzAttributes & 2) == 2 )");
            this.println("            zzPushbackPosL = zzCurrentPosL;");
            this.println();
        }
        this.println("          if ( (zzAttributes & 1) == 1 ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            zzWasPushback = (zzAttributes & 4) == 4;");
        }
        this.skel.emitNext();
        this.println("            if ( (zzAttributes & 8) == 8 ) break zzForAction;");
        this.skel.emitNext();
    }

    private void emitTransitionTable() {
        this.transformTransitionTable();
        this.println("          zzInput = zzCMapL[zzInput];");
        this.println();
        if (this.scanner.lookAheadUsed) {
            this.println("          boolean zzPushback = false;");
        }
        this.println("          boolean zzIsFinal = false;");
        this.println("          boolean zzNoLookAhead = false;");
        this.println();
        this.println("          zzForNext: { switch (zzState) {");
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (!this.isTransition[i]) continue;
            this.emitState(i);
        }
        this.println("            default:");
        this.println("              // if this is ever reached, there is a serious bug in JFlex");
        this.println("              zzScanError(ZZ_UNKNOWN_ERROR);");
        this.println("              break;");
        this.println("          } }");
        this.println();
        this.println("          if ( zzIsFinal ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            zzWasPushback = zzPushback;");
        }
        this.skel.emitNext();
        this.println("            if ( zzNoLookAhead ) break zzForAction;");
        this.skel.emitNext();
    }

    private String escapify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\r': {
                    if (i + 1 != string.length() && string.charAt(i + 1) == '\n') continue block8;
                    stringBuffer.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void emitActionTable() {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        this.println("  /** ");
        this.println("   * Translates DFA states to action switch labels.");
        this.println("   */");
        CountEmitter countEmitter = new CountEmitter("Action");
        countEmitter.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            int n4;
            if (this.dfa.isFinal[i]) {
                Action action = this.dfa.action[i];
                Integer n5 = (Integer)this.actionTable.get(action);
                if (n5 == null) {
                    n5 = new Integer(n++);
                    this.actionTable.put(action, n5);
                }
                n4 = n5;
            } else {
                n4 = 0;
            }
            if (n3 == n4) {
                ++n2;
                continue;
            }
            if (n2 > 0) {
                countEmitter.emit(n2, n3);
            }
            n2 = 1;
            n3 = n4;
        }
        if (n2 > 0) {
            countEmitter.emit(n2, n3);
        }
        countEmitter.emitUnpack();
        this.println(countEmitter.toString());
    }

    private void emitActions() {
        this.println("      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {");
        int n = this.actionTable.size() + 1;
        Enumeration enumeration = this.actionTable.keys();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            int n2 = (Integer)this.actionTable.get(action);
            this.println("        case " + n2 + ": ");
            if (this.scanner.debugOption) {
                this.print("          System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: --\"+yytext()+\"--\");");
                this.print("          System.out.println(\"action [" + action.priority + "] { ");
                this.print(this.escapify(action.content));
                this.println(" }\");");
            }
            this.println("          { " + action.content);
            this.println("          }");
            this.println("        case " + n++ + ": break;");
        }
    }

    private void emitEOFVal() {
        Object object;
        EOFActions eOFActions = this.parser.getEOFActions();
        if (this.scanner.eofCode != null) {
            this.println("            zzDoEOF();");
        }
        if (eOFActions.numActions() > 0) {
            this.println("            switch (zzLexicalState) {");
            object = this.scanner.states.names();
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            int n = this.dfa.numStates;
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                int n2 = this.scanner.states.getNumber(string);
                Action action = eOFActions.getAction(n2);
                boolean bl = true;
                if (!this.scanner.bolUsed) {
                    Integer n3 = new Integer(this.dfa.lexState[2 * n2]);
                    boolean bl2 = bl = hashtable.get(n3) == null;
                    if (!bl) {
                        Out.warning("Lexical states <" + string + "> and <" + hashtable.get(n3) + "> are equivalent.");
                    } else {
                        hashtable.put(n3, string);
                    }
                }
                if (action == null || !bl) continue;
                this.println("            case " + string + ": {");
                if (this.scanner.debugOption) {
                    this.print("              System.out.println(");
                    if (this.scanner.lineCount) {
                        this.print("\"line: \"+(yyline+1)+\" \"+");
                    }
                    if (this.scanner.columnCount) {
                        this.print("\"col: \"+(yycolumn+1)+\" \"+");
                    }
                    this.println("\"match: <<EOF>>\");");
                    this.print("              System.out.println(\"action [" + action.priority + "] { ");
                    this.print(this.escapify(action.content));
                    this.println(" }\");");
                }
                this.println("              " + action.content);
                this.println("            }");
                this.println("            case " + ++n + ": break;");
            }
            this.println("            default:");
        }
        if ((object = eOFActions.getDefault()) != null) {
            this.println("              {");
            if (this.scanner.debugOption) {
                this.print("                System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: <<EOF>>\");");
                this.print("                System.out.println(\"action [" + ((Action)object).priority + "] { ");
                this.print(this.escapify(((Action)object).content));
                this.println(" }\");");
            }
            this.println("                " + ((Action)object).content);
            this.println("              }");
        } else if (this.scanner.eofVal != null) {
            this.println("              { " + this.scanner.eofVal + " }");
        } else if (this.scanner.isInteger) {
            this.println("            return YYEOF;");
        } else {
            this.println("            return null;");
        }
        if (eOFActions.numActions() > 0) {
            this.println("            }");
        }
    }

    private void emitState(int n) {
        this.println("            case " + n + ":");
        this.println("              switch (zzInput) {");
        int n2 = this.getDefaultTransition(n);
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (i == n2 || this.table[n][i] == null) continue;
            this.emitTransition(n, i);
        }
        if (n2 != -1 && this.noTarget[n] != null) {
            this.emitTransition(n, -1);
        }
        this.emitDefaultTransition(n, n2);
        this.println("              }");
        this.println("");
    }

    private void emitTransition(int n, int n2) {
        CharSetEnumerator charSetEnumerator = n2 != -1 ? this.table[n][n2].characters() : this.noTarget[n].characters();
        this.print("                case ");
        this.print(charSetEnumerator.nextElement());
        this.print(": ");
        while (charSetEnumerator.hasMoreElements()) {
            this.println();
            this.print("                case ");
            this.print(charSetEnumerator.nextElement());
            this.print(": ");
        }
        if (n2 != -1) {
            if (this.dfa.isFinal[n2]) {
                this.print("zzIsFinal = true; ");
            }
            if (this.dfa.isPushback[n2]) {
                this.print("zzPushbackPosL = zzCurrentPosL; ");
            }
            if (this.dfa.isLookEnd[n2]) {
                this.print("zzPushback = true; ");
            }
            if (!this.isTransition[n2]) {
                this.print("zzNoLookAhead = true; ");
            }
            if (n2 == n) {
                this.println("break zzForNext;");
            } else {
                this.println("zzState = " + n2 + "; break zzForNext;");
            }
        } else {
            this.println("break zzForAction;");
        }
    }

    private void emitDefaultTransition(int n, int n2) {
        this.print("                default: ");
        if (n2 != -1) {
            if (this.dfa.isFinal[n2]) {
                this.print("zzIsFinal = true; ");
            }
            if (this.dfa.isPushback[n2]) {
                this.print("zzPushbackPosL = zzCurrentPosL; ");
            }
            if (this.dfa.isLookEnd[n2]) {
                this.print("zzPushback = true; ");
            }
            if (!this.isTransition[n2]) {
                this.print("zzNoLookAhead = true; ");
            }
            if (n2 == n) {
                this.println("break zzForNext;");
            } else {
                this.println("zzState = " + n2 + "; break zzForNext;");
            }
        } else {
            this.println("break zzForAction;");
        }
    }

    private void emitPushback() {
        this.println("      if (zzWasPushback)");
        this.println("        zzMarkedPos = zzPushbackPosL;");
    }

    private int getDefaultTransition(int n) {
        int n2 = 0;
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (this.table[n][n2] == null) {
                n2 = i;
                continue;
            }
            if (this.table[n][i] == null || this.table[n][n2].size() >= this.table[n][i].size()) continue;
            n2 = i;
        }
        if (this.table[n][n2] == null) {
            return -1;
        }
        if (this.noTarget[n] == null) {
            return n2;
        }
        if (this.table[n][n2].size() < this.noTarget[n].size()) {
            n2 = -1;
        }
        return n2;
    }

    private void transformTransitionTable() {
        int n = this.parser.getCharClasses().getNumClasses() + 1;
        this.table = new CharSet[this.dfa.numStates][this.dfa.numStates];
        this.noTarget = new CharSet[this.dfa.numStates];
        for (int i = 0; i < this.dfa.numStates; ++i) {
            for (int n2 = 0; n2 < this.dfa.numInput; n2 = (int)((char)(n2 + 1))) {
                int n3 = this.dfa.table[i][n2];
                if (n3 == -1) {
                    if (this.noTarget[i] == null) {
                        this.noTarget[i] = new CharSet(n, this.colMap[n2]);
                        continue;
                    }
                    this.noTarget[i].add(this.colMap[n2]);
                    continue;
                }
                if (this.table[i][n3] == null) {
                    this.table[i][n3] = new CharSet(n, this.colMap[n2]);
                    continue;
                }
                this.table[i][n3].add(this.colMap[n2]);
            }
        }
    }

    private void findActionStates() {
        this.isTransition = new boolean[this.dfa.numStates];
        for (int i = 0; i < this.dfa.numStates; ++i) {
            for (int n = 0; !this.isTransition[i] && n < this.dfa.numInput; n = (int)((char)(n + 1))) {
                int n2 = n;
                this.isTransition[i] = this.dfa.table[i][n2] != -1;
            }
        }
    }

    private void reduceColumns() {
        this.colMap = new int[this.dfa.numInput];
        this.colKilled = new boolean[this.dfa.numInput];
        int n = 0;
        this.numCols = this.dfa.numInput;
        block0: for (int i = 0; i < this.dfa.numInput; ++i) {
            this.colMap[i] = i - n;
            for (int j = 0; j < i; ++j) {
                int n2 = -1;
                boolean bl = true;
                while (bl && ++n2 < this.dfa.numStates) {
                    bl = this.dfa.table[n2][i] == this.dfa.table[n2][j];
                }
                if (!bl) continue;
                ++n;
                this.colMap[i] = this.colMap[j];
                this.colKilled[i] = true;
                --this.numCols;
                continue block0;
            }
        }
    }

    private void reduceRows() {
        this.rowMap = new int[this.dfa.numStates];
        this.rowKilled = new boolean[this.dfa.numStates];
        int n = 0;
        this.numRows = this.dfa.numStates;
        block0: for (int i = 0; i < this.dfa.numStates; ++i) {
            this.rowMap[i] = i - n;
            for (int j = 0; j < i; ++j) {
                int n2 = -1;
                boolean bl = true;
                while (bl && ++n2 < this.dfa.numInput) {
                    bl = this.dfa.table[i][n2] == this.dfa.table[j][n2];
                }
                if (!bl) continue;
                ++n;
                this.rowMap[i] = this.rowMap[j];
                this.rowKilled[i] = true;
                --this.numRows;
                continue block0;
            }
        }
    }

    private void setupEOFCode() {
        if (this.scanner.eofclose) {
            this.scanner.eofCode = LexScan.conc(this.scanner.eofCode, "  yyclose();");
            this.scanner.eofThrow = LexScan.concExc(this.scanner.eofThrow, "java.io.IOException");
        }
    }

    public void emit() {
        this.setupEOFCode();
        if (this.scanner.functionName == null) {
            this.scanner.functionName = "yylex";
        }
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  private static final int ZZ_BUFFERSIZE = " + this.scanner.bufferSize + ";");
        if (this.scanner.debugOption) {
            this.println("  private static final String ZZ_NL = System.getProperty(\"line.separator\");");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        this.emitCharMapArray();
        this.emitActionTable();
        if (this.scanner.useRowMap) {
            this.reduceRows();
            this.emitRowMapArray();
            if (this.scanner.packed) {
                this.emitDynamicInit();
            } else {
                this.emitZZTrans();
            }
        }
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.emitAttributes();
        }
        this.skel.emitNext();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitConstructorDecl();
        this.emitCharMapInitFunction();
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader();
        this.emitNextInput();
        if (this.scanner.useRowMap) {
            this.emitGetRowMapNext();
        } else {
            this.emitTransitionTable();
        }
        if (this.scanner.lookAheadUsed) {
            this.emitPushback();
        }
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain();
        this.skel.emitNext();
        this.out.close();
    }
}

