/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class PrincipalComponents
extends UnsupervisedAttributeEvaluator
implements AttributeTransformer,
OptionHandler {
    static final long serialVersionUID = 3310137541055815078L;
    private Instances m_trainInstances;
    private Instances m_trainCopy;
    private Instances m_transformedFormat;
    private Instances m_originalSpaceFormat;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private double[][] m_correlation;
    private double[][] m_eigenvectors;
    private double[] m_eigenvalues = null;
    private int[] m_sortedEigens;
    private double m_sumOfEigenValues = 0.0;
    private ReplaceMissingValues m_replaceMissingFilter;
    private Normalize m_normalizeFilter;
    private NominalToBinary m_nominalToBinFilter;
    private Remove m_attributeFilter;
    private Remove m_attribFilter;
    private int m_outputNumAtts = -1;
    private boolean m_normalize = true;
    private double m_coverVariance = 0.95;
    private boolean m_transBackToOriginal = false;
    private int m_maxAttrsInName = 5;
    private double[][] m_eTranspose;

    public String globalInfo() {
        return "Performs a principal components analysis and transformation of the data. Use in conjunction with a Ranker search. Dimensionality reduction is accomplished by choosing enough eigenvectors to account for some percentage of the variance in the original data---default 0.95 (95%). Attribute noise can be filtered by transforming to the PC space, eliminating some of the worst eigenvectors, and then transforming back to the original space.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tDon't normalize input data.", "D", 0, "-D"));
        vector.addElement(new Option("\tRetain enough PC attributes to account \n\tfor this proportion of variance in the original data.\n\t(default = 0.95)", "R", 1, "-R"));
        vector.addElement(new Option("\tTransform through the PC space and \n\tback to the original space.", "O", 0, "-O"));
        vector.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names. (-1 = include all)", "A", 1, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            Double d = Double.valueOf(string);
            this.setVarianceCovered(d);
        }
        if ((string = Utils.getOption('A', stringArray)).length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(string));
        }
        this.setNormalize(!Utils.getFlag('D', stringArray));
        this.setTransformBackToOriginal(Utils.getFlag('O', stringArray));
    }

    private void resetOptions() {
        this.m_coverVariance = 0.95;
        this.m_normalize = true;
        this.m_sumOfEigenValues = 0.0;
        this.m_transBackToOriginal = false;
    }

    public String normalizeTipText() {
        return "Normalize input data.";
    }

    public void setNormalize(boolean bl) {
        this.m_normalize = bl;
    }

    public boolean getNormalize() {
        return this.m_normalize;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setVarianceCovered(double d) {
        this.m_coverVariance = d;
    }

    public double getVarianceCovered() {
        return this.m_coverVariance;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int n) {
        this.m_maxAttrsInName = n;
    }

    public int getMaximumAttributeNames() {
        return this.m_maxAttrsInName;
    }

    public String transformBackToOriginalTipText() {
        return "Transform through the PC space and back to the original space. If only the best n PCs are retained (by setting varianceCovered < 1) then this option will give a dataset in the original space but with less attribute noise.";
    }

    public void setTransformBackToOriginal(boolean bl) {
        this.m_transBackToOriginal = bl;
    }

    public boolean getTransformBackToOriginal() {
        return this.m_transBackToOriginal;
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        if (!this.getNormalize()) {
            stringArray[n++] = "-D";
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getVarianceCovered();
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.getMaximumAttributeNames();
        if (this.getTransformBackToOriginal()) {
            stringArray[n++] = "-O";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.buildAttributeConstructor(instances);
    }

    private void buildAttributeConstructor(Instances instances) throws Exception {
        int n;
        this.m_eigenvalues = null;
        this.m_outputNumAtts = -1;
        this.m_attributeFilter = null;
        this.m_nominalToBinFilter = null;
        this.m_sumOfEigenValues = 0.0;
        this.m_trainInstances = new Instances(instances);
        this.m_trainCopy = new Instances(this.m_trainInstances);
        this.m_replaceMissingFilter = new ReplaceMissingValues();
        this.m_replaceMissingFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_replaceMissingFilter);
        if (this.m_normalize) {
            this.m_normalizeFilter = new Normalize();
            this.m_normalizeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_normalizeFilter);
        }
        this.m_nominalToBinFilter = new NominalToBinary();
        this.m_nominalToBinFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_nominalToBinFilter);
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.m_trainInstances.numAttributes(); ++i) {
            if (this.m_trainInstances.numDistinctValues(i) > 1) continue;
            vector.addElement(new Integer(i));
        }
        if (this.m_trainInstances.classIndex() >= 0) {
            this.m_hasClass = true;
            this.m_classIndex = this.m_trainInstances.classIndex();
            vector.addElement(new Integer(this.m_classIndex));
        }
        if (vector.size() > 0) {
            this.m_attributeFilter = new Remove();
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray[i] = (Integer)vector.elementAt(i);
            }
            this.m_attributeFilter.setAttributeIndicesArray(nArray);
            this.m_attributeFilter.setInvertSelection(false);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_attributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_trainInstances);
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.fillCorrelation();
        double[] dArray = new double[this.m_numAttribs];
        double[][] dArray2 = new double[this.m_numAttribs][this.m_numAttribs];
        Matrix matrix = new Matrix(this.m_correlation);
        matrix.eigenvalueDecomposition(dArray2, dArray);
        this.m_eigenvectors = (double[][])dArray2.clone();
        this.m_eigenvalues = (double[])dArray.clone();
        for (n = 0; n < this.m_eigenvalues.length; ++n) {
            if (!(this.m_eigenvalues[n] < 0.0)) continue;
            this.m_eigenvalues[n] = 0.0;
        }
        this.m_sortedEigens = Utils.sort(this.m_eigenvalues);
        this.m_sumOfEigenValues = Utils.sum(this.m_eigenvalues);
        this.m_transformedFormat = this.setOutputFormat();
        if (this.m_transBackToOriginal) {
            int n2;
            int n3;
            this.m_originalSpaceFormat = this.setOutputFormatOriginal();
            n = this.m_transformedFormat.classIndex() < 0 ? this.m_transformedFormat.numAttributes() : this.m_transformedFormat.numAttributes() - 1;
            double[][] dArray3 = new double[this.m_eigenvectors.length][n + 1];
            for (n3 = this.m_numAttribs - 1; n3 > this.m_numAttribs - n - 1; --n3) {
                for (n2 = 0; n2 < this.m_numAttribs; ++n2) {
                    dArray3[n2][this.m_numAttribs - n3] = this.m_eigenvectors[n2][this.m_sortedEigens[n3]];
                }
            }
            n3 = dArray3.length;
            n2 = dArray3[0].length;
            this.m_eTranspose = new double[n2][n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.m_eTranspose[i][j] = dArray3[j][i];
                }
            }
        }
    }

    public Instances transformedHeader() throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        if (this.m_transBackToOriginal) {
            return this.m_originalSpaceFormat;
        }
        return this.m_transformedFormat;
    }

    public Instances transformedData() throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        Instances instances = this.m_transBackToOriginal ? new Instances(this.m_originalSpaceFormat) : new Instances(this.m_transformedFormat);
        for (int i = 0; i < this.m_trainCopy.numInstances(); ++i) {
            Instance instance = this.convertInstance(this.m_trainCopy.instance(i));
            instances.add(instance);
        }
        return instances;
    }

    public double evaluateAttribute(int n) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet!");
        }
        if (this.m_transBackToOriginal) {
            return 1.0;
        }
        double d = 0.0;
        for (int i = this.m_numAttribs - 1; i >= this.m_numAttribs - n - 1; --i) {
            d += this.m_eigenvalues[this.m_sortedEigens[i]];
        }
        return 1.0 - d / this.m_sumOfEigenValues;
    }

    private void fillCorrelation() {
        this.m_correlation = new double[this.m_numAttribs][this.m_numAttribs];
        double[] dArray = new double[this.m_numInstances];
        double[] dArray2 = new double[this.m_numInstances];
        for (int i = 0; i < this.m_numAttribs; ++i) {
            for (int j = 0; j < this.m_numAttribs; ++j) {
                double d;
                if (i == j) {
                    this.m_correlation[i][j] = 1.0;
                    continue;
                }
                for (int k = 0; k < this.m_numInstances; ++k) {
                    dArray[k] = this.m_trainInstances.instance(k).value(i);
                    dArray2[k] = this.m_trainInstances.instance(k).value(j);
                }
                this.m_correlation[i][j] = d = Utils.correlation(dArray, dArray2, this.m_numInstances);
                this.m_correlation[j][i] = d;
            }
        }
    }

    private String principalComponentsSummary() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        double d = 0.0;
        Instances instances = null;
        int n2 = 0;
        try {
            instances = this.setOutputFormat();
            n2 = instances.classIndex() < 0 ? instances.numAttributes() : instances.numAttributes() - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("Correlation matrix\n" + this.matrixToString(this.m_correlation) + "\n\n");
        stringBuffer.append("eigenvalue\tproportion\tcumulative\n");
        for (n = this.m_numAttribs - 1; n > this.m_numAttribs - n2 - 1; --n) {
            stringBuffer.append(Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[n]], 9, 5) + "\t" + Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[n]] / this.m_sumOfEigenValues, 9, 5) + "\t" + Utils.doubleToString((d += this.m_eigenvalues[this.m_sortedEigens[n]]) / this.m_sumOfEigenValues, 9, 5) + "\t" + instances.attribute(this.m_numAttribs - n - 1).name() + "\n");
        }
        stringBuffer.append("\nEigenvectors\n");
        for (n = 1; n <= n2; ++n) {
            stringBuffer.append(" V" + n + '\t');
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.m_numAttribs; ++n) {
            for (int i = this.m_numAttribs - 1; i > this.m_numAttribs - n2 - 1; --i) {
                stringBuffer.append(Utils.doubleToString(this.m_eigenvectors[n][this.m_sortedEigens[i]], 7, 4) + "\t");
            }
            stringBuffer.append(this.m_trainInstances.attribute(n).name() + '\n');
        }
        if (this.m_transBackToOriginal) {
            stringBuffer.append("\nPC space transformed back to original space.\n(Note: can't evaluate attributes in the original space)\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.m_eigenvalues == null) {
            return "Principal components hasn't been built yet!";
        }
        return "\tPrincipal Components Attribute Transformer\n\n" + this.principalComponentsSummary();
    }

    private String matrixToString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = dArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                stringBuffer.append(Utils.doubleToString(dArray[i][j], 6, 2) + " ");
                if (j != n) continue;
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    private Instance convertInstanceToOriginal(Instance instance) throws Exception {
        double[] dArray = null;
        dArray = this.m_hasClass ? new double[this.m_numAttribs + 1] : new double[this.m_numAttribs];
        if (this.m_hasClass) {
            dArray[this.m_numAttribs] = instance.value(instance.numAttributes() - 1);
        }
        for (int i = 0; i < this.m_eTranspose[0].length; ++i) {
            double d = 0.0;
            for (int j = 1; j < this.m_eTranspose.length; ++j) {
                d += this.m_eTranspose[j][i] * instance.value(j - 1);
            }
            dArray[i] = d;
        }
        if (instance instanceof SparseInstance) {
            return new SparseInstance(instance.weight(), dArray);
        }
        return new Instance(instance.weight(), dArray);
    }

    public Instance convertInstance(Instance instance) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("convertInstance: Principal components not built yet");
        }
        double[] dArray = new double[this.m_outputNumAtts];
        Instance instance2 = (Instance)instance.copy();
        if (!instance.equalHeaders(this.m_trainCopy.instance(0))) {
            throw new Exception("Can't convert instance: header's don't match: PrincipalComponents");
        }
        this.m_replaceMissingFilter.input(instance2);
        this.m_replaceMissingFilter.batchFinished();
        instance2 = this.m_replaceMissingFilter.output();
        if (this.m_normalize) {
            this.m_normalizeFilter.input(instance2);
            this.m_normalizeFilter.batchFinished();
            instance2 = this.m_normalizeFilter.output();
        }
        this.m_nominalToBinFilter.input(instance2);
        this.m_nominalToBinFilter.batchFinished();
        instance2 = this.m_nominalToBinFilter.output();
        if (this.m_attributeFilter != null) {
            this.m_attributeFilter.input(instance2);
            this.m_attributeFilter.batchFinished();
            instance2 = this.m_attributeFilter.output();
        }
        if (this.m_hasClass) {
            dArray[this.m_outputNumAtts - 1] = instance.value(instance.classIndex());
        }
        double d = 0.0;
        for (int i = this.m_numAttribs - 1; i >= 0; --i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m_numAttribs; ++j) {
                d2 += this.m_eigenvectors[j][this.m_sortedEigens[i]] * instance2.value(j);
            }
            dArray[this.m_numAttribs - i - 1] = d2;
            if ((d += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
        }
        if (!this.m_transBackToOriginal) {
            if (instance instanceof SparseInstance) {
                return new SparseInstance(instance.weight(), dArray);
            }
            return new Instance(instance.weight(), dArray);
        }
        if (instance instanceof SparseInstance) {
            return this.convertInstanceToOriginal(new SparseInstance(instance.weight(), dArray));
        }
        return this.convertInstanceToOriginal(new Instance(instance.weight(), dArray));
    }

    private Instances setOutputFormatOriginal() throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            String string = this.m_trainInstances.attribute(i).name();
            fastVector.addElement(new Attribute(string));
        }
        if (this.m_hasClass) {
            fastVector.addElement(this.m_trainCopy.classAttribute().copy());
        }
        Instances instances = new Instances(this.m_trainCopy.relationName() + "->PC->original space", fastVector, 0);
        if (this.m_hasClass) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        return instances;
    }

    private Instances setOutputFormat() throws Exception {
        if (this.m_eigenvalues == null) {
            return null;
        }
        double d = 0.0;
        FastVector fastVector = new FastVector();
        for (int i = this.m_numAttribs - 1; i >= 0; --i) {
            int n;
            int[] nArray;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            double[] dArray = new double[this.m_numAttribs];
            for (n2 = 0; n2 < this.m_numAttribs; ++n2) {
                dArray[n2] = -Math.abs(this.m_eigenvectors[n2][this.m_sortedEigens[i]]);
            }
            int n3 = n2 = this.m_maxAttrsInName > 0 ? Math.min(this.m_numAttribs, this.m_maxAttrsInName) : this.m_numAttribs;
            if (this.m_numAttribs > 0) {
                nArray = Utils.sort(dArray);
            } else {
                nArray = new int[this.m_numAttribs];
                for (n = 0; n < this.m_numAttribs; ++n) {
                    nArray[n] = n;
                }
            }
            for (n = 0; n < n2; ++n) {
                double d2 = this.m_eigenvectors[nArray[n]][this.m_sortedEigens[i]];
                if (n > 0 && d2 >= 0.0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(Utils.doubleToString(d2, 5, 3) + this.m_trainInstances.attribute(nArray[n]).name());
            }
            if (n2 < this.m_numAttribs) {
                stringBuffer.append("...");
            }
            fastVector.addElement(new Attribute(stringBuffer.toString()));
            if ((d += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
        }
        if (this.m_hasClass) {
            fastVector.addElement(this.m_trainCopy.classAttribute().copy());
        }
        Instances instances = new Instances(this.m_trainInstances.relationName() + "_principal components", fastVector, 0);
        if (this.m_hasClass) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        this.m_outputNumAtts = instances.numAttributes();
        return instances;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.36 $");
    }

    public static void main(String[] stringArray) {
        PrincipalComponents.runEvaluator(new PrincipalComponents(), stringArray);
    }
}

