/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.ClassDiscovery;

public class SortedTableModel
extends AbstractTableModel
implements TableModelListener {
    static final long serialVersionUID = 4030907921461127548L;
    protected TableModel mModel;
    protected int[] mIndices;
    protected int mSortColumn;
    protected boolean mAscending;

    public SortedTableModel() {
        this(null);
    }

    public SortedTableModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        this.mModel = tableModel;
        if (this.mModel == null) {
            this.mIndices = null;
        } else {
            this.initializeIndices();
            this.mSortColumn = -1;
            this.mAscending = true;
            this.mModel.addTableModelListener(this);
        }
    }

    protected void initializeIndices() {
        this.mIndices = new int[this.mModel.getRowCount()];
        for (int i = 0; i < this.mIndices.length; ++i) {
            this.mIndices[i] = i;
        }
    }

    public TableModel getModel() {
        return this.mModel;
    }

    public boolean isSorted() {
        return this.mSortColumn > -1;
    }

    protected boolean isInitialized() {
        return this.getModel() != null;
    }

    public int getActualRow(int n) {
        if (!this.isInitialized()) {
            return -1;
        }
        return this.mIndices[n];
    }

    public Class getColumnClass(int n) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnClass(n);
    }

    public int getColumnCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getColumnCount();
    }

    public String getColumnName(int n) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnName(n);
    }

    public int getRowCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getValueAt(this.mIndices[n], n2);
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.getModel().isCellEditable(this.mIndices[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.isInitialized()) {
            this.getModel().setValueAt(object, this.mIndices[n], n2);
        }
    }

    public void sort(int n) {
        this.sort(n, true);
    }

    public void sort(int n, boolean bl) {
        int n2;
        int n3;
        if (!this.isInitialized() || this.getModel().getRowCount() != this.mIndices.length) {
            System.out.println(this.getClass().getName() + ": Table model not initialized!");
            return;
        }
        this.mSortColumn = n;
        this.mAscending = bl;
        this.initializeIndices();
        int n4 = ClassDiscovery.isSubclass(Number.class, this.getColumnClass(this.mSortColumn)) ? 1 : (ClassDiscovery.isSubclass(Date.class, this.getColumnClass(this.mSortColumn)) ? 2 : 0);
        for (n3 = 0; n3 < this.getRowCount() - 1; ++n3) {
            int n5 = n3;
            for (int i = n3 + 1; i < this.getRowCount(); ++i) {
                if (this.compare(this.mIndices[n5], this.mIndices[i], this.mSortColumn, n4) <= 0) continue;
                n5 = i;
            }
            if (n5 == n3) continue;
            n2 = this.mIndices[n3];
            this.mIndices[n3] = this.mIndices[n5];
            this.mIndices[n5] = n2;
        }
        if (!this.mAscending) {
            for (n3 = 0; n3 < this.getRowCount() / 2; ++n3) {
                n2 = this.mIndices[n3];
                this.mIndices[n3] = this.mIndices[this.getRowCount() - n3 - 1];
                this.mIndices[this.getRowCount() - n3 - 1] = n2;
            }
        }
    }

    protected int compare(int n, int n2, int n3, int n4) {
        int n5;
        Object object = this.getModel().getValueAt(n, n3);
        Object object2 = this.getModel().getValueAt(n2, n3);
        if (object == null && object2 == null) {
            n5 = 0;
        } else if (object == null) {
            n5 = -1;
        } else if (object2 == null) {
            n5 = 1;
        } else {
            switch (n4) {
                case 1: {
                    Double d = new Double(((Number)object).doubleValue());
                    Double d2 = new Double(((Number)object2).doubleValue());
                    n5 = d.compareTo(d2);
                    break;
                }
                case 2: {
                    n5 = ((Date)object).compareTo((Date)object2);
                    break;
                }
                default: {
                    n5 = object.toString().compareTo(object2.toString());
                }
            }
        }
        return n5;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.initializeIndices();
        if (this.isSorted()) {
            this.sort(this.mSortColumn, this.mAscending);
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void addMouseListenerToHeader(JTable jTable) {
        final SortedTableModel sortedTableModel = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        JTableHeader jTableHeader = jTable2.getTableHeader();
        if (jTableHeader != null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    TableColumnModel tableColumnModel = jTable2.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = jTable2.convertColumnIndexToModel(n);
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && !mouseEvent.isAltDown() && n2 != -1) {
                        int n3 = mouseEvent.getModifiers() & 1;
                        boolean bl = n3 == 0;
                        sortedTableModel.sort(n2, bl);
                    }
                }
            };
            jTableHeader.addMouseListener(mouseAdapter);
        }
    }
}

