/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class SimpleLinkedList
implements Serializable {
    private static final long serialVersionUID = -1491148276509976299L;
    private Entry first = new Entry(null, null, null);
    private Entry last;

    public SimpleLinkedList() {
        this.first.next = this.last = new Entry(null, null, null);
        this.last.previous = this.first;
    }

    public Object removeFirst() {
        if (this.first.next == this.last) {
            throw new NoSuchElementException();
        }
        Object object = this.first.next.element;
        this.first.next.next.previous = this.first;
        this.first.next = this.first.next.next;
        return object;
    }

    public Object getFirst() {
        if (this.first.next == this.last) {
            throw new NoSuchElementException();
        }
        return this.first.next.element;
    }

    public Object getLast() {
        if (this.last.previous == this.first) {
            throw new NoSuchElementException();
        }
        return this.last.previous.element;
    }

    public void addFirst(Object object) {
        Entry entry;
        this.first.next.previous = entry = new Entry(object, this.first.next, this.first);
        this.first.next = entry;
    }

    public void add(Object object) {
        Entry entry;
        this.last.previous.next = entry = new Entry(object, this.last, this.last.previous);
        this.last.previous = entry;
    }

    public void addAll(SimpleLinkedList simpleLinkedList) {
        this.last.previous.next = simpleLinkedList.first.next;
        simpleLinkedList.first.next.previous = this.last.previous;
        this.last = simpleLinkedList.last;
    }

    public void clear() {
        this.first.next = this.last;
        this.last.previous = this.first;
    }

    public boolean isEmpty() {
        return this.first.next == this.last;
    }

    public LinkedListIterator iterator() {
        return new LinkedListIterator();
    }

    public LinkedListInverseIterator inverseIterator() {
        return new LinkedListInverseIterator();
    }

    public int size() {
        int n = 0;
        LinkedListIterator linkedListIterator = new LinkedListIterator();
        while (linkedListIterator.hasNext()) {
            ++n;
            linkedListIterator.next();
        }
        return n;
    }

    public void merge(SimpleLinkedList simpleLinkedList, Comparator comparator) {
        LinkedListIterator linkedListIterator = this.iterator();
        LinkedListIterator linkedListIterator2 = simpleLinkedList.iterator();
        Object object = linkedListIterator.next();
        Object object2 = linkedListIterator2.next();
        while (object2 != null) {
            if (object == null || comparator.compare(object2, object) < 0) {
                linkedListIterator.addBefore(object2);
                object2 = linkedListIterator2.next();
                continue;
            }
            object = linkedListIterator.next();
        }
    }

    public void sort(Comparator comparator) {
        LinkedListIterator linkedListIterator = this.iterator();
        if (linkedListIterator.hasNext()) {
            SimpleLinkedList simpleLinkedList = new SimpleLinkedList();
            SimpleLinkedList simpleLinkedList2 = new SimpleLinkedList();
            Object object = linkedListIterator.next();
            while (linkedListIterator.hasNext()) {
                Object object2 = linkedListIterator.next();
                if (comparator.compare(object2, object) < 0) {
                    simpleLinkedList.add(object2);
                    continue;
                }
                simpleLinkedList2.add(object2);
            }
            simpleLinkedList.sort(comparator);
            simpleLinkedList2.sort(comparator);
            this.clear();
            this.addAll(simpleLinkedList);
            this.add(object);
            this.addAll(simpleLinkedList2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedListIterator linkedListIterator = this.iterator();
        stringBuffer.append("[");
        while (linkedListIterator.hasNext()) {
            stringBuffer.append(String.valueOf(linkedListIterator.next()));
            if (!linkedListIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Entry entry = this.first.next;
        while (entry != this.last) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.first = new Entry(null, null, null);
        this.first.next = this.last = new Entry(null, null, null);
        this.last.previous = this.first;
        for (int i = 0; i < n; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 7888492479685339831L;
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }

    public class LinkedListInverseIterator
    implements Serializable {
        private static final long serialVersionUID = 6290379064027832108L;
        Entry current;
        Entry lastReturned;

        public LinkedListInverseIterator() {
            this.current = SimpleLinkedList.this.last;
            this.lastReturned = null;
        }

        public boolean hasPrevious() {
            return this.current.previous != SimpleLinkedList.this.first;
        }

        public Object previous() {
            if (this.current == SimpleLinkedList.this.first) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.current = this.current.previous;
            return this.current.element;
        }

        public void remove() {
            if (this.lastReturned == SimpleLinkedList.this.first || this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = this.lastReturned.next;
            this.lastReturned.next.previous = this.lastReturned.previous;
            this.current = this.lastReturned.next;
            this.lastReturned = null;
        }
    }

    public class LinkedListIterator
    implements Serializable {
        private static final long serialVersionUID = -2448555236100426759L;
        Entry current;
        Entry lastReturned;

        public LinkedListIterator() {
            this.current = SimpleLinkedList.this.first;
            this.lastReturned = null;
        }

        public boolean hasNext() {
            return this.current.next != SimpleLinkedList.this.last;
        }

        public Object next() {
            if (this.current == SimpleLinkedList.this.last) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.current = this.current.next;
            return this.current.element;
        }

        public void remove() {
            if (this.lastReturned == SimpleLinkedList.this.last || this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = this.lastReturned.next;
            this.lastReturned.next.previous = this.lastReturned.previous;
            this.current = this.lastReturned.previous;
            this.lastReturned = null;
        }

        public void addBefore(Object object) {
            Entry entry;
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = entry = new Entry(object, this.lastReturned, this.lastReturned.previous);
            this.lastReturned.previous = entry;
        }
    }
}

