/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeSelection;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class GainRatioAttributeEval
extends AttributeEvaluator
implements OptionHandler {
    static final long serialVersionUID = -8504656625598579926L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private int m_numClasses;
    private boolean m_missing_merge;

    public String globalInfo() {
        return "GainRatioAttributeEval :\n\nEvaluates the worth of an attribute by measuring the gain ratio with respect to the class.\n\nGainR(Class, Attribute) = (H(Class) - H(Class | Attribute)) / H(Attribute).\n";
    }

    public GainRatioAttributeEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', stringArray));
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean bl) {
        this.m_missing_merge = bl;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    public String[] getOptions() {
        String[] stringArray = new String[1];
        int n = 0;
        if (!this.getMissingMerge()) {
            stringArray[n++] = "-M";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Can't handle string attributes!");
        }
        this.m_trainInstances = instances;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        if (this.m_trainInstances.attribute(this.m_classIndex).isNumeric()) {
            throw new Exception("Class must be nominal!");
        }
        Discretize discretize = new Discretize();
        discretize.setUseBetterEncoding(true);
        discretize.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, discretize);
        this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missing_merge = true;
    }

    public double evaluateAttribute(int n) throws Exception {
        int n2;
        int n3;
        double d = 0.0;
        int n4 = this.m_trainInstances.attribute(n).numValues() + 1;
        int n5 = this.m_numClasses + 1;
        double d2 = 0.0;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n4][n5];
        dArray = new double[n4];
        dArray2 = new double[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = 0.0;
            for (n2 = 0; n2 < n5; ++n2) {
                dArray2[n2] = 0.0;
                dArray3[n3][n2] = 0.0;
            }
        }
        for (n3 = 0; n3 < this.m_numInstances; ++n3) {
            Instance instance = this.m_trainInstances.instance(n3);
            int n6 = instance.isMissing(n) ? n4 - 1 : (int)instance.value(n);
            int n7 = instance.isMissing(this.m_classIndex) ? n5 - 1 : (int)instance.value(this.m_classIndex);
            double[] dArray4 = dArray3[n6];
            int n8 = n7;
            dArray4[n8] = dArray4[n8] + 1.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = 0.0;
            for (n2 = 0; n2 < n5; ++n2) {
                int n9 = n3;
                dArray[n9] = dArray[n9] + dArray3[n3][n2];
                d += dArray3[n3][n2];
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            dArray2[n2] = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                int n10 = n2;
                dArray2[n10] = dArray2[n10] + dArray3[n3][n2];
            }
        }
        if (this.m_missing_merge && dArray[n4 - 1] < (double)this.m_numInstances && dArray2[n5 - 1] < (double)this.m_numInstances) {
            double[] dArray5 = new double[dArray.length];
            double[] dArray6 = new double[dArray2.length];
            double[][] dArray7 = new double[dArray.length][dArray2.length];
            for (n3 = 0; n3 < n4; ++n3) {
                System.arraycopy(dArray3[n3], 0, dArray7[n3], 0, dArray2.length);
            }
            System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray6, 0, dArray2.length);
            double d3 = dArray[n4 - 1] + dArray2[n5 - 1] - dArray3[n4 - 1][n5 - 1];
            if (dArray[n4 - 1] > 0.0) {
                for (n2 = 0; n2 < n5 - 1; ++n2) {
                    if (!(dArray3[n4 - 1][n2] > 0.0)) continue;
                    n3 = 0;
                    while (n3 < n4 - 1) {
                        d2 = dArray5[n3] / (d - dArray5[n4 - 1]) * dArray3[n4 - 1][n2];
                        double[] dArray8 = dArray3[n3];
                        int n11 = n2;
                        dArray8[n11] = dArray8[n11] + d2;
                        int n12 = n3++;
                        dArray[n12] = dArray[n12] + d2;
                    }
                    dArray3[n4 - 1][n2] = 0.0;
                }
            }
            dArray[n4 - 1] = 0.0;
            if (dArray2[n5 - 1] > 0.0) {
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    if (!(dArray3[n3][n5 - 1] > 0.0)) continue;
                    n2 = 0;
                    while (n2 < n5 - 1) {
                        d2 = dArray6[n2] / (d - dArray6[n5 - 1]) * dArray3[n3][n5 - 1];
                        double[] dArray9 = dArray3[n3];
                        int n13 = n2;
                        dArray9[n13] = dArray9[n13] + d2;
                        int n14 = n2++;
                        dArray2[n14] = dArray2[n14] + d2;
                    }
                    dArray3[n3][n5 - 1] = 0.0;
                }
            }
            dArray2[n5 - 1] = 0.0;
            if (dArray3[n4 - 1][n5 - 1] > 0.0 && d3 != d) {
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    n2 = 0;
                    while (n2 < n5 - 1) {
                        d2 = dArray7[n3][n2] / (d - d3) * dArray7[n4 - 1][n5 - 1];
                        double[] dArray10 = dArray3[n3];
                        int n15 = n2;
                        dArray10[n15] = dArray10[n15] + d2;
                        int n16 = n3;
                        dArray[n16] = dArray[n16] + d2;
                        int n17 = n2++;
                        dArray2[n17] = dArray2[n17] + d2;
                    }
                }
                dArray3[n4 - 1][n5 - 1] = 0.0;
            }
        }
        return ContingencyTables.gainRatio(dArray3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("\tGain Ratio evaluator has not been built");
        } else {
            stringBuffer.append("\tGain Ratio feature evaluator");
            if (!this.m_missing_merge) {
                stringBuffer.append("\n\tMissing values treated as seperate");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new GainRatioAttributeEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

