/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weka.core.AttributeStats;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MathExpression
extends PotentialClassIgnorer
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -3713222714671997901L;
    protected Range m_SelectCols = new Range();
    public static final String m_defaultExpression = "(A-MIN)/(MAX-MIN)";
    private String m_expression = "(A-MIN)/(MAX-MIN)";
    private Parser.TreeNode m_expTree = null;
    private AttributeStats[] m_attStats;

    public MathExpression() {
        this.setInvertSelection(false);
    }

    public String globalInfo() {
        return "Modify numeric attributes according to a given expression ";
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_SelectCols.setUpper(instances.numAttributes() - 1);
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_attStats = null;
        this.m_expTree = null;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_attStats == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_attStats == null) {
            int n;
            Instances instances = this.getInputFormat();
            this.m_expTree = Parser.parse(this.getExpression());
            this.m_attStats = new AttributeStats[instances.numAttributes()];
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (!instances.attribute(n).isNumeric() || instances.classIndex() == n) continue;
                this.m_attStats[n] = instances.attributeStats(n);
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.convertInstance(instances.instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) throws Exception {
        Instance instance2 = null;
        HashMap<String, Double> hashMap = new HashMap<String, Double>(5);
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numAttributes()];
            int[] nArray = new int[instance.numAttributes()];
            double[] dArray2 = instance.toDoubleArray();
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                double d;
                if (!this.m_SelectCols.isInRange(i)) continue;
                if (instance.attribute(i).isNumeric() && !Instance.isMissingValue(dArray2[i]) && this.getInputFormat().classIndex() != i) {
                    hashMap.put("A", new Double(dArray2[i]));
                    hashMap.put("MAX", new Double(this.m_attStats[i].numericStats.max));
                    hashMap.put("MIN", new Double(this.m_attStats[i].numericStats.min));
                    hashMap.put("MEAN", new Double(this.m_attStats[i].numericStats.mean));
                    hashMap.put("SD", new Double(this.m_attStats[i].numericStats.stdDev));
                    hashMap.put("COUNT", new Double(this.m_attStats[i].numericStats.count));
                    hashMap.put("SUM", new Double(this.m_attStats[i].numericStats.sum));
                    hashMap.put("SUMSQUARED", new Double(this.m_attStats[i].numericStats.sumSq));
                    d = this.m_expTree.eval(hashMap);
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        System.err.println("WARNING:Error in evaluating the expression: missing value set");
                        d = Instance.missingValue();
                    }
                    if (d == 0.0) continue;
                    dArray[n] = d;
                    nArray[n] = i;
                    ++n;
                    continue;
                }
                d = dArray2[i];
                if (d == 0.0) continue;
                dArray[n] = d;
                nArray[n] = i;
                ++n;
            }
            double[] dArray3 = new double[n];
            int[] nArray2 = new int[n];
            System.arraycopy(dArray, 0, dArray3, 0, n);
            System.arraycopy(nArray, 0, nArray2, 0, n);
            instance2 = new SparseInstance(instance.weight(), dArray3, nArray2, instance.numAttributes());
        } else {
            double[] dArray = instance.toDoubleArray();
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (!this.m_SelectCols.isInRange(i) || !instance.attribute(i).isNumeric() || Instance.isMissingValue(dArray[i]) || this.getInputFormat().classIndex() == i) continue;
                hashMap.put("A", new Double(dArray[i]));
                hashMap.put("MAX", new Double(this.m_attStats[i].numericStats.max));
                hashMap.put("MIN", new Double(this.m_attStats[i].numericStats.min));
                hashMap.put("MEAN", new Double(this.m_attStats[i].numericStats.mean));
                hashMap.put("SD", new Double(this.m_attStats[i].numericStats.stdDev));
                hashMap.put("COUNT", new Double(this.m_attStats[i].numericStats.count));
                hashMap.put("SUM", new Double(this.m_attStats[i].numericStats.sum));
                hashMap.put("SUMSQUARED", new Double(this.m_attStats[i].numericStats.sumSq));
                dArray[i] = this.m_expTree.eval(hashMap);
                if (!Double.isNaN(dArray[i]) && !Double.isInfinite(dArray[i])) continue;
                System.err.println("WARNING:Error in Evaluation the Expression: missing value set");
                dArray[i] = Instance.missingValue();
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExpression(string);
        } else {
            this.setExpression(m_defaultExpression);
        }
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setIgnoreRange(string2);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-E";
        stringArray[n++] = this.getExpression();
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getIgnoreRange().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getIgnoreRange();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSpecify the expression to apply. Eg. pow(A,6)/(MEAN+MAX)\n\tSupported operators are +, -, *, /, pow, log,\n\tabs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ), \n\tMEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse", "E", 1, "-E <expression>"));
        vector.addElement(new Option("\tSpecify list of columns to ignore. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense (i.e. only modify specified columns)", "V", 0, "-V"));
        return vector.elements();
    }

    public String expressionTipText() {
        return "Specify the expression to apply. The 'A' letterrefers to the attribute value. MIN,MAX,MEAN,SDrefer respectively to minimum, maximum, mean andstandard deviation of the attribute.\n\tSupported operators are +, -, *, /, pow, log,abs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ),A,MEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse\n\tEg. pow(A,6)/(MEAN+MAX)*ifelse(A<0,0,sqrt(A))+ifelse(![A>9 && A<15])";
    }

    public void setExpression(String string) {
        this.m_expression = string;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or unselect. If set to true, only the specified attributes will be modified; If set to false, specified attributes will not be modified.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_SelectCols.setInvert(!bl);
    }

    public String ignoreRangeTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getIgnoreRange() {
        return this.m_SelectCols.getRanges();
    }

    public void setIgnoreRange(String string) {
        this.m_SelectCols.setRanges(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new MathExpression(), stringArray);
            } else {
                Filter.filterFile(new MathExpression(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }

    public static class Parser {
        public static TreeNode parse(String string) throws Exception {
            Tokenizer tokenizer = new Tokenizer(new StringReader(string));
            tokenizer.nextToken();
            TreeNode treeNode = Parser.parseExp(tokenizer);
            if (tokenizer.ttype != -1) {
                throw new Exception("Syntax Error: end of file expected.");
            }
            return treeNode;
        }

        public static TreeNode parseExp(Tokenizer tokenizer) throws Exception {
            Vector<TreeNode> vector = new Vector<TreeNode>();
            vector.add(Parser.parseTerm(tokenizer));
            switch (tokenizer.ttype) {
                case 43: {
                    tokenizer.nextToken();
                    vector.add(Parser.parseExp(tokenizer));
                    return new TreeNode(43, vector);
                }
                case 45: {
                    tokenizer.nextToken();
                    vector.add(Parser.parseExp(tokenizer));
                    return new TreeNode(45, vector);
                }
            }
            return (TreeNode)vector.get(0);
        }

        public static TreeNode parseTerm(Tokenizer tokenizer) throws Exception {
            Vector<TreeNode> vector = new Vector<TreeNode>();
            vector.add(Parser.parseAtom(tokenizer));
            switch (tokenizer.ttype) {
                case 42: {
                    tokenizer.nextToken();
                    vector.add(Parser.parseTerm(tokenizer));
                    return new TreeNode(42, vector);
                }
                case 47: {
                    tokenizer.nextToken();
                    vector.add(Parser.parseTerm(tokenizer));
                    return new TreeNode(47, vector);
                }
            }
            return (TreeNode)vector.get(0);
        }

        public static TreeNode parseAtom(Tokenizer tokenizer) throws Exception {
            switch (tokenizer.ttype) {
                case -2: {
                    TreeNode treeNode = new TreeNode(tokenizer.nval);
                    tokenizer.nextToken();
                    return treeNode;
                }
                case 40: {
                    tokenizer.nextToken();
                    TreeNode treeNode = Parser.parseExp(tokenizer);
                    if (tokenizer.ttype != 41) {
                        throw new Exception("Syntax Error: ')' expected.");
                    }
                    tokenizer.nextToken();
                    return treeNode;
                }
                case 45: {
                    tokenizer.nextToken();
                    Vector<TreeNode> vector = new Vector<TreeNode>(1);
                    vector.add(Parser.parseAtom(tokenizer));
                    return new TreeNode(45, vector);
                }
                case -5: {
                    TreeNode treeNode = new TreeNode(tokenizer.sval);
                    tokenizer.nextToken();
                    return treeNode;
                }
                case -7: {
                    tokenizer.nextToken();
                    if (tokenizer.ttype != 40) {
                        throw new Exception("Syntax Error: '(' expected.");
                    }
                    tokenizer.nextToken();
                    Vector<TreeNode> vector = new Vector<TreeNode>(3);
                    vector.add(Parser.parseDisjunction(tokenizer));
                    if (tokenizer.ttype != 44) {
                        throw new Exception("Syntax Error: ',' expected.");
                    }
                    tokenizer.nextToken();
                    vector.add(Parser.parseExp(tokenizer));
                    if (tokenizer.ttype != 44) {
                        throw new Exception("Syntax Error: ',' expected.");
                    }
                    tokenizer.nextToken();
                    vector.add(Parser.parseExp(tokenizer));
                    if (tokenizer.ttype != 41) {
                        throw new Exception("Syntax Error: ',' expected.");
                    }
                    tokenizer.nextToken();
                    return new TreeNode(vector);
                }
                case -6: {
                    String string = tokenizer.sval;
                    tokenizer.nextToken();
                    if (tokenizer.ttype != 40) {
                        throw new Exception("Syntax Error: '(' expected.");
                    }
                    tokenizer.nextToken();
                    Vector<TreeNode> vector = new Vector<TreeNode>(1);
                    vector.add(Parser.parseExp(tokenizer));
                    while (tokenizer.ttype == 44) {
                        tokenizer.nextToken();
                        vector.add(Parser.parseExp(tokenizer));
                    }
                    if (tokenizer.ttype != 41) {
                        throw new Exception("Syntax Error: ')' expected.");
                    }
                    tokenizer.nextToken();
                    return new TreeNode(string, vector);
                }
            }
            throw new Exception("Syntax Error: Unexpected token");
        }

        public static TreeNode parseDisjunction(Tokenizer tokenizer) throws Exception {
            Vector<TreeNode> vector = new Vector<TreeNode>(2);
            vector.add(Parser.parseConjunction(tokenizer));
            if (tokenizer.ttype != 124) {
                return (TreeNode)vector.get(0);
            }
            tokenizer.nextToken();
            vector.add(Parser.parseDisjunction(tokenizer));
            return new TreeNode(124, vector);
        }

        public static TreeNode parseConjunction(Tokenizer tokenizer) throws Exception {
            Vector<TreeNode> vector = new Vector<TreeNode>(2);
            vector.add(Parser.parseNumTest(tokenizer));
            if (tokenizer.ttype != 38) {
                return (TreeNode)vector.get(0);
            }
            tokenizer.nextToken();
            vector.add(Parser.parseConjunction(tokenizer));
            return new TreeNode(38, vector);
        }

        public static TreeNode parseNumTest(Tokenizer tokenizer) throws Exception {
            switch (tokenizer.ttype) {
                case 91: {
                    tokenizer.nextToken();
                    TreeNode treeNode = Parser.parseDisjunction(tokenizer);
                    if (tokenizer.ttype != 93) {
                        throw new Exception("']' expected");
                    }
                    tokenizer.nextToken();
                    return treeNode;
                }
                case 33: {
                    tokenizer.nextToken();
                    if (tokenizer.ttype != 91) {
                        throw new Exception("'[' expected after '!'");
                    }
                    tokenizer.nextToken();
                    TreeNode treeNode = Parser.parseDisjunction(tokenizer);
                    if (tokenizer.ttype != 93) {
                        throw new Exception("']' expected");
                    }
                    tokenizer.nextToken();
                    return new TreeNode(treeNode);
                }
            }
            Vector<TreeNode> vector = new Vector<TreeNode>(2);
            vector.add(Parser.parseExp(tokenizer));
            int n = tokenizer.ttype;
            if (n != 60 && n != 62 && n != 61) {
                throw new Exception("Unknow test " + (char)tokenizer.ttype);
            }
            tokenizer.nextToken();
            vector.add(Parser.parseExp(tokenizer));
            return new TreeNode(n, vector);
        }

        public static class TreeNode
        implements Serializable {
            static final long serialVersionUID = -654720966350007711L;
            public static String[] funs = new String[]{"abs", "sqrt", "log", "exp", "sin", "cos", "tan", "rint", "floor", "pow", "ceil"};
            public static int[] arity = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1};
            int type;
            double nval;
            String sval = null;
            TreeNode[] operands = null;

            TreeNode(double d) {
                this.type = -2;
                this.nval = d;
            }

            TreeNode(TreeNode treeNode) {
                this.type = 33;
                this.operands = new TreeNode[1];
                this.operands[0] = treeNode;
            }

            TreeNode(String string) {
                this.type = -5;
                this.sval = string;
            }

            TreeNode(Vector vector) {
                this.type = -7;
                this.operands = new TreeNode[vector.size()];
                for (int i = 0; i < this.operands.length; ++i) {
                    this.operands[i] = (TreeNode)vector.elementAt(i);
                }
            }

            TreeNode(String string, Vector vector) throws Exception {
                int n;
                for (n = 0; n < funs.length && !funs[n].equals(string); ++n) {
                }
                if (n >= funs.length) {
                    throw new Exception("Unknow function " + string);
                }
                if (arity[n] != vector.size()) {
                    throw new Exception("Wrong Number of argument in " + string);
                }
                this.type = -6;
                this.nval = n;
                this.operands = new TreeNode[vector.size()];
                for (n = 0; n < this.operands.length; ++n) {
                    this.operands[n] = (TreeNode)vector.elementAt(n);
                }
            }

            TreeNode(int n, Vector vector) throws Exception {
                this.type = n;
                this.operands = new TreeNode[vector.size()];
                for (int i = 0; i < this.operands.length; ++i) {
                    this.operands[i] = (TreeNode)vector.elementAt(i);
                }
            }

            public double eval(Map map) throws Exception {
                switch (this.type) {
                    case -2: {
                        return this.nval;
                    }
                    case -5: {
                        if (!map.containsKey(this.sval)) {
                            throw new Exception("Unknow symbol " + this.sval);
                        }
                        return (Double)map.get(this.sval);
                    }
                    case 43: {
                        return this.operands[0].eval(map) + this.operands[1].eval(map);
                    }
                    case 45: {
                        if (this.operands.length > 1) {
                            return this.operands[0].eval(map) - this.operands[1].eval(map);
                        }
                        return -this.operands[0].eval(map);
                    }
                    case 42: {
                        return this.operands[0].eval(map) * this.operands[1].eval(map);
                    }
                    case 47: {
                        return this.operands[0].eval(map) / this.operands[1].eval(map);
                    }
                    case 62: {
                        return this.operands[0].eval(map) > this.operands[1].eval(map) ? 1.0 : 0.0;
                    }
                    case 60: {
                        return this.operands[0].eval(map) < this.operands[1].eval(map) ? 1.0 : 0.0;
                    }
                    case 61: {
                        return this.operands[0].eval(map) == this.operands[1].eval(map) ? 1.0 : 0.0;
                    }
                    case 38: {
                        return this.operands[0].eval(map) == 1.0 && this.operands[1].eval(map) == 1.0 ? 1.0 : 0.0;
                    }
                    case 124: {
                        return this.operands[0].eval(map) == 1.0 || this.operands[1].eval(map) == 1.0 ? 1.0 : 0.0;
                    }
                    case 33: {
                        return this.operands[0].eval(map) == 1.0 ? 0.0 : 1.0;
                    }
                    case -6: {
                        switch ((int)this.nval) {
                            case 0: {
                                return Math.abs(this.operands[0].eval(map));
                            }
                            case 1: {
                                return Math.sqrt(this.operands[0].eval(map));
                            }
                            case 2: {
                                return Math.log(this.operands[0].eval(map));
                            }
                            case 3: {
                                return Math.exp(this.operands[0].eval(map));
                            }
                            case 4: {
                                return Math.sin(this.operands[0].eval(map));
                            }
                            case 5: {
                                return Math.cos(this.operands[0].eval(map));
                            }
                            case 6: {
                                return Math.tan(this.operands[0].eval(map));
                            }
                            case 7: {
                                return Math.rint(this.operands[0].eval(map));
                            }
                            case 8: {
                                return Math.floor(this.operands[0].eval(map));
                            }
                            case 9: {
                                return Math.pow(this.operands[0].eval(map), this.operands[1].eval(map));
                            }
                            case 10: {
                                return Math.ceil(this.operands[0].eval(map));
                            }
                        }
                        throw new Exception("Unknow Function");
                    }
                    case -7: {
                        return this.operands[0].eval(map) == 1.0 ? this.operands[1].eval(map) : this.operands[2].eval(map);
                    }
                }
                throw new Exception("Unknow Tree Node Type.");
            }
        }

        public static class Tokenizer
        extends StreamTokenizer {
            static final int TT_VAR = -5;
            static final int TT_FUN = -6;
            static final int TT_IFELSE = -7;

            public Tokenizer(Reader reader) {
                super(reader);
                this.resetSyntax();
                this.parseNumbers();
                this.whitespaceChars(32, 32);
                this.wordChars(97, 122);
                this.wordChars(65, 90);
                this.ordinaryChar(45);
            }

            public int nextToken() throws IOException {
                super.nextToken();
                if (this.ttype == -3) {
                    this.ttype = this.sval.equals("ifelse") ? -7 : (Character.isUpperCase(this.sval.charAt(0)) ? -5 : -6);
                }
                return this.ttype;
            }
        }
    }
}

