/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AbstractTimeSeries;

public class TimeSeriesTranslate
extends AbstractTimeSeries {
    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the equivalent attribute attribute values of some previous (or future) instance. For instances where the desired value is unknown either the instance may  be dropped, or missing values used.";
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        Instances instances2 = new Instances(instances, 0);
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (!this.m_SelectedCols.isInRange(i)) continue;
            if (instances2.attribute(i).isNominal() || instances2.attribute(i).isNumeric()) {
                instances2.renameAttribute(i, instances2.attribute(i).name() + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                continue;
            }
            throw new UnsupportedAttributeTypeException("Only numeric and nominal attributes may be  manipulated in time series.");
        }
        this.setOutputFormat(instances2);
        return true;
    }

    protected Instance mergeInstances(Instance instance, Instance instance2) {
        Instances instances = this.outputFormatPeek();
        double[] dArray = new double[instances.numAttributes()];
        for (int i = 0; i < dArray.length; ++i) {
            if (this.m_SelectedCols.isInRange(i)) {
                if (instance != null) {
                    dArray[i] = instance.value(i);
                    continue;
                }
                dArray[i] = Instance.missingValue();
                continue;
            }
            dArray[i] = instance2.value(i);
        }
        Instance instance3 = null;
        instance3 = instance2 instanceof SparseInstance ? new SparseInstance(instance2.weight(), dArray) : new Instance(instance2.weight(), dArray);
        instance3.setDataset(instance2.dataset());
        return instance3;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new TimeSeriesTranslate(), stringArray);
            } else {
                Filter.filterFile(new TimeSeriesTranslate(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

