/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class Ridor
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -7261533075088314436L;
    private int m_Folds = 3;
    private int m_Shuffle = 1;
    private Random m_Random = null;
    private int m_Seed = 1;
    private boolean m_IsAllErr = false;
    private boolean m_IsMajority = false;
    private Ridor_node m_Root = null;
    private Attribute m_Class;
    private double m_Cover;
    private double m_Err;
    private double m_MinNo = 2.0;

    public String globalInfo() {
        return "The implementation of a RIpple-DOwn Rule learner.\n\nIt generates a default rule first and then the exceptions for the default rule with the least (weighted) error rate.  Then it generates the \"best\" exceptions for each exception and iterates until pure.  Thus it performs a tree-like expansion of exceptions.The exceptions are a set of rules that predict classes other than the default. IREP is used to generate the exceptions.\n\nFor more information about Ripple-Down Rules, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Brian R. Gaines and Paul Compton");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Induction of Ripple-Down Rules Applied to Modeling Large Databases");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "J. Intell. Inf. Syst.");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "5");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "3");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "211-228");
        technicalInformation.setValue(TechnicalInformation.Field.PDF, "http://pages.cpsc.ucalgary.ca/~gaines/reports/ML/JIIS95/JIIS95.pdf");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        int n2 = instances2.numClasses();
        this.m_Root = new Ridor_node();
        this.m_Class = instances.classAttribute();
        int n3 = instances2.classIndex();
        this.m_Cover = instances2.sumOfWeights();
        FastVector fastVector = new FastVector(2);
        fastVector.addElement("otherClasses");
        fastVector.addElement("defClass");
        Attribute attribute = new Attribute("newClass", fastVector);
        instances2.insertAttributeAt(attribute, n3);
        instances2.setClassIndex(n3);
        Instances[] instancesArray = new Instances[n2];
        for (n = 0; n < n2; ++n) {
            instancesArray[n] = new Instances(instances2, instances2.numInstances());
        }
        for (n = 0; n < instances2.numInstances(); ++n) {
            Instance instance = instances2.instance(n);
            instance.setClassValue(0.0);
            instancesArray[(int)instance.value(n3 + 1)].add(instance);
        }
        for (n = 0; n < n2; ++n) {
            instancesArray[n].deleteAttributeAt(n3 + 1);
        }
        this.m_Root.findRules(instancesArray, 0);
    }

    public double classifyInstance(Instance instance) {
        return this.classify(this.m_Root, instance);
    }

    private double classify(Ridor_node ridor_node, Instance instance) {
        double d = ridor_node.getDefClass();
        RidorRule[] ridorRuleArray = ridor_node.getRules();
        if (ridorRuleArray != null) {
            Ridor_node[] ridor_nodeArray = ridor_node.getExcepts();
            for (int i = 0; i < ridor_nodeArray.length; ++i) {
                if (!ridorRuleArray[i].isCover(instance)) continue;
                d = this.classify(ridor_nodeArray[i], instance);
                break;
            }
        }
        return d;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tSet number of folds for IREP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        vector.addElement(new Option("\tSet number of shuffles to randomize\n\tthe data in order to get better rule.\n\t(default 10)", "S", 1, "-S <number of shuffles>"));
        vector.addElement(new Option("\tSet flag of whether use the error rate \n\tof all the data to select the default class\n\tin each step. If not set, the learner will only use\tthe error rate in the pruning data", "A", 0, "-A"));
        vector.addElement(new Option("\t Set flag of whether use the majority class as\n\tthe default class in each step instead of \n\tchoosing default class based on the error rate\n\t(if the flag is not set)", "M", 0, "-M"));
        vector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        this.m_Folds = string.length() != 0 ? Integer.parseInt(string) : 3;
        String string2 = Utils.getOption('S', stringArray);
        this.m_Shuffle = string2.length() != 0 ? Integer.parseInt(string2) : 1;
        String string3 = Utils.getOption('s', stringArray);
        this.m_Seed = string3.length() != 0 ? Integer.parseInt(string3) : 1;
        String string4 = Utils.getOption('N', stringArray);
        this.m_MinNo = string4.length() != 0 ? Double.parseDouble(string4) : 2.0;
        this.m_IsAllErr = Utils.getFlag('A', stringArray);
        this.m_IsMajority = Utils.getFlag('M', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.m_Folds;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Shuffle;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_MinNo;
        if (this.m_IsAllErr) {
            stringArray[n++] = "-A";
        }
        if (this.m_IsMajority) {
            stringArray[n++] = "-M";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int n) {
        this.m_Folds = n;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String shuffleTipText() {
        return "Determines how often the data is shuffled before a rule is chosen. If > 1, a rule is learned multiple times and the most accurate rule is chosen.";
    }

    public void setShuffle(int n) {
        this.m_Shuffle = n;
    }

    public int getShuffle() {
        return this.m_Shuffle;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String wholeDataErrTipText() {
        return "Whether worth of rule is computed based on all the data or just based on data covered by rule.";
    }

    public void setWholeDataErr(boolean bl) {
        this.m_IsAllErr = bl;
    }

    public boolean getWholeDataErr() {
        return this.m_IsAllErr;
    }

    public String majorityClassTipText() {
        return "Whether the majority class is used as default.";
    }

    public void setMajorityClass(boolean bl) {
        this.m_IsMajority = bl;
    }

    public boolean getMajorityClass() {
        return this.m_IsMajority;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double d) {
        this.m_MinNo = d;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.numRules();
        }
        throw new IllegalArgumentException(string + " not supported (Ripple down rule learner)");
    }

    private double numRules() {
        int n = 0;
        if (this.m_Root != null) {
            n = this.m_Root.size();
        }
        return n + 1;
    }

    public String toString() {
        if (this.m_Root == null) {
            return "RIpple DOwn Rule Learner(Ridor): No model built yet.";
        }
        return "RIpple DOwn Rule Learner(Ridor) rules\n--------------------------------------\n\n" + this.m_Root.toString() + "\nTotal number of rules (incl. the default rule): " + (int)this.numRules();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Ridor(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    private class NominalAntd
    extends Antd {
        static final long serialVersionUID = -256386137196078004L;
        private double[] accurate;
        private double[] coverage;
        private double[] infoGain;

        public NominalAntd(Attribute attribute) {
            super(attribute);
            int n = this.att.numValues();
            this.accurate = new double[n];
            this.coverage = new double[n];
            this.infoGain = new double[n];
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            int n;
            int n2 = this.att.numValues();
            Instances[] instancesArray = new Instances[n2];
            for (n = 0; n < n2; ++n) {
                this.infoGain[n] = 0.0;
                this.coverage[n] = 0.0;
                this.accurate[n] = 0.0;
                instancesArray[n] = new Instances(instances, instances.numInstances());
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                Instance instance = instances.instance(n);
                if (instance.isMissing(this.att)) continue;
                int n3 = (int)instance.value(this.att);
                instancesArray[n3].add(instance);
                int n4 = n3;
                this.coverage[n4] = this.coverage[n4] + instance.weight();
                if (!Utils.eq(instance.classValue(), d2)) continue;
                int n5 = n3;
                this.accurate[n5] = this.accurate[n5] + instance.weight();
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                double d3 = this.coverage[i];
                if (!Utils.grOrEq(d3, Ridor.this.m_MinNo)) continue;
                double d4 = this.accurate[i];
                if (!Utils.eq(d3, 0.0)) {
                    this.infoGain[i] = d4 * (Utils.log2(d4 / d3) - Utils.log2(d));
                }
                ++n;
            }
            if (n < 2) {
                return null;
            }
            this.value = Utils.maxIndex(this.infoGain);
            this.cover = this.coverage[(int)this.value];
            this.accu = this.accurate[(int)this.value];
            this.accuRate = !Utils.eq(this.cover, 0.0) ? this.accu / this.cover : 0.0;
            this.maxInfoGain = this.infoGain[(int)this.value];
            return instancesArray;
        }

        public boolean isCover(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att) && Utils.eq(instance.value(this.att), this.value)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }
    }

    private class NumericAntd
    extends Antd {
        static final long serialVersionUID = 1968761518014492214L;
        private double splitPoint;

        public NumericAntd(Attribute attribute) {
            super(attribute);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            Instance instance;
            int n;
            Instances instances2 = new Instances(instances);
            instances2.sort(this.att);
            int n2 = instances2.numInstances();
            int n3 = 1;
            int n4 = 0;
            int n5 = n3;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double d3 = 0.1 * instances2.sumOfWeights() / 2.0;
            if (Utils.smOrEq(d3, Ridor.this.m_MinNo)) {
                d3 = Ridor.this.m_MinNo;
            } else if (Utils.gr(d3, 25.0)) {
                d3 = 25.0;
            }
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            for (n = 0; n < instances2.numInstances(); ++n) {
                instance = instances2.instance(n);
                if (instance.isMissing(this.att)) {
                    n2 = n;
                    break;
                }
                d5 += instance.weight();
                if (!Utils.eq(instance.classValue(), d2)) continue;
                d7 += instance.weight();
            }
            if (Utils.sm(d5, 2.0 * d3)) {
                return null;
            }
            if (n2 == 0) {
                return null;
            }
            this.splitPoint = instances2.instance(n2 - 1).value(this.att);
            while (n3 < n2) {
                if (!Utils.eq(instances2.instance(n3).value(this.att), instances2.instance(n4).value(this.att))) {
                    for (n = n4; n < n3; ++n) {
                        instance = instances2.instance(n);
                        d4 += instance.weight();
                        d5 -= instance.weight();
                        if (!Utils.eq(instances2.instance(n).classValue(), d2)) continue;
                        d6 += instance.weight();
                        d7 -= instance.weight();
                    }
                    if (Utils.sm(d4, d3) || Utils.sm(d5, d3)) {
                        n4 = n3;
                    } else {
                        double d8;
                        double d9;
                        double d10;
                        double d11;
                        boolean bl;
                        double d12;
                        double d13 = 0.0;
                        double d14 = 0.0;
                        if (!Utils.eq(d4, 0.0)) {
                            d13 = d6 / d4;
                        }
                        if (!Utils.eq(d5, 0.0)) {
                            d14 = d7 / d5;
                        }
                        double d15 = Utils.eq(d13, 0.0) ? 0.0 : d6 * (Utils.log2(d13) - Utils.log2(d));
                        double d16 = d12 = Utils.eq(d14, 0.0) ? 0.0 : d7 * (Utils.log2(d14) - Utils.log2(d));
                        if (Utils.gr(d15, d12) || Utils.eq(d15, d12) && Utils.grOrEq(d13, d14)) {
                            bl = true;
                            d11 = d15;
                            d10 = d13;
                            d9 = d6;
                            d8 = d4;
                        } else {
                            bl = false;
                            d11 = d12;
                            d10 = d14;
                            d9 = d7;
                            d8 = d5;
                        }
                        boolean bl2 = Utils.gr(d11, this.maxInfoGain);
                        if (bl2) {
                            this.splitPoint = (instances2.instance(n3).value(this.att) + instances2.instance(n4).value(this.att)) / 2.0;
                            this.value = !bl ? 1 : 0;
                            this.accuRate = d10;
                            this.accu = d9;
                            this.cover = d8;
                            this.maxInfoGain = d11;
                            n5 = n3;
                        }
                        n4 = n3;
                    }
                }
                ++n3;
            }
            Instances[] instancesArray = new Instances[]{new Instances(instances2, 0, n5), new Instances(instances2, n5, n2 - n5)};
            return instancesArray;
        }

        public boolean isCover(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att)) {
                if (Utils.eq(this.value, 0.0)) {
                    if (Utils.smOrEq(instance.value(this.att), this.splitPoint)) {
                        bl = true;
                    }
                } else if (Utils.gr(instance.value(this.att), this.splitPoint)) {
                    bl = true;
                }
            }
            return bl;
        }

        public String toString() {
            String string = Utils.eq(this.value, 0.0) ? " <= " : " > ";
            return this.att.name() + string + Utils.doubleToString(this.splitPoint, 6);
        }
    }

    private abstract class Antd
    implements Serializable {
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute attribute) {
            this.att = attribute;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean isCover(Instance var1);

        public abstract String toString();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }
    }

    private class RidorRule
    implements WeightedInstancesHandler,
    Serializable {
        static final long serialVersionUID = 4375199423973848157L;
        private double m_Class = -1.0;
        private Attribute m_ClassAttribute;
        protected FastVector m_Antds = null;
        private double m_WorthRate = 0.0;
        private double m_Worth = 0.0;
        private double m_CoverP = 0.0;
        private double m_CoverG = 0.0;
        private double m_AccuG = 0.0;

        private RidorRule() {
        }

        public void setPredictedClass(double d) {
            this.m_Class = d;
        }

        public double getPredictedClass() {
            return this.m_Class;
        }

        public void buildClassifier(Instances instances) throws Exception {
            this.m_ClassAttribute = instances.classAttribute();
            if (!this.m_ClassAttribute.isNominal()) {
                throw new UnsupportedClassTypeException(" Only nominal class, please.");
            }
            if (instances.numClasses() != 2) {
                throw new Exception(" Only 2 classes, please.");
            }
            Instances instances2 = new Instances(instances);
            if (Utils.eq(instances2.sumOfWeights(), 0.0)) {
                throw new Exception(" No training data.");
            }
            instances2.deleteWithMissingClass();
            if (Utils.eq(instances2.sumOfWeights(), 0.0)) {
                throw new Exception(" The class labels of all the training data are missing.");
            }
            if (instances2.numInstances() < Ridor.this.m_Folds) {
                throw new Exception(" Not enough data for REP.");
            }
            this.m_Antds = new FastVector();
            Ridor.this.m_Random = new Random(Ridor.this.m_Seed);
            instances2.randomize(Ridor.this.m_Random);
            instances2.stratify(Ridor.this.m_Folds);
            Instances instances3 = instances2.trainCV(Ridor.this.m_Folds, Ridor.this.m_Folds - 1, Ridor.this.m_Random);
            Instances instances4 = instances2.testCV(Ridor.this.m_Folds, Ridor.this.m_Folds - 1);
            this.grow(instances3);
            this.prune(instances4);
        }

        public Instances[] coveredByRule(Instances instances) {
            Instances[] instancesArray = new Instances[]{new Instances(instances, instances.numInstances()), new Instances(instances, instances.numInstances())};
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (this.isCover(instance)) {
                    instancesArray[0].add(instance);
                    continue;
                }
                instancesArray[1].add(instance);
            }
            return instancesArray;
        }

        public boolean isCover(Instance instance) {
            boolean bl = true;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.isCover(instance)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        private void grow(Instances instances) {
            int n;
            Instances instances2 = new Instances(instances);
            this.m_AccuG = this.computeDefAccu(instances2);
            this.m_CoverG = instances2.sumOfWeights();
            double d = this.m_AccuG / this.m_CoverG;
            boolean[] blArray = new boolean[instances2.numAttributes()];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            n = blArray.length;
            boolean bl = true;
            while (bl) {
                double d2 = 0.0;
                Antd antd = null;
                Instances instances3 = null;
                Enumeration enumeration = instances2.enumerateAttributes();
                int n2 = -1;
                while (enumeration.hasMoreElements()) {
                    double d3;
                    Instances instances4;
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    Antd antd2 = null;
                    antd2 = attribute.isNumeric() ? new NumericAntd(attribute) : new NominalAntd(attribute);
                    if (blArray[++n2] || (instances4 = this.computeInfoGain(instances2, d, antd2)) == null || !Utils.gr(d3 = antd2.getMaxInfoGain(), d2)) continue;
                    antd = antd2;
                    instances3 = instances4;
                    d2 = d3;
                }
                if (antd == null) {
                    return;
                }
                if (!antd.getAttr().isNumeric()) {
                    blArray[antd.getAttr().index()] = true;
                    --n;
                }
                this.m_Antds.addElement(antd);
                instances2 = instances3;
                d = antd.getAccuRate();
                if (!Utils.eq(instances2.sumOfWeights(), 0.0) && !Utils.eq(d, 1.0) && n != 0) continue;
                bl = false;
            }
        }

        private Instances computeInfoGain(Instances instances, double d, Antd antd) {
            Instances instances2 = new Instances(instances);
            Instances[] instancesArray = antd.splitData(instances2, d, this.m_Class);
            if (instancesArray != null) {
                return instancesArray[(int)antd.getAttrValue()];
            }
            return null;
        }

        private void prune(Instances instances) {
            Antd antd;
            int n;
            Instances instances2 = new Instances(instances);
            double d = instances2.sumOfWeights();
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = this.m_Antds.size();
            if (n2 == 0) {
                return;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray3[n] = 0.0;
                dArray2[n] = 0.0;
                dArray[n] = 0.0;
            }
            for (n = 0; n < n2; ++n) {
                antd = (Antd)this.m_Antds.elementAt(n);
                Attribute attribute = antd.getAttr();
                Instances instances3 = new Instances(instances2);
                instances2 = new Instances(instances3, instances3.numInstances());
                for (int i = 0; i < instances3.numInstances(); ++i) {
                    Instance instance = instances3.instance(i);
                    if (instance.isMissing(attribute) || !antd.isCover(instance)) continue;
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + instance.weight();
                    instances2.add(instance);
                    if (!Utils.eq(instance.classValue(), this.m_Class)) continue;
                    int n4 = n;
                    dArray3[n4] = dArray3[n4] + instance.weight();
                }
                if (dArray2[n] == 0.0) continue;
                dArray[n] = dArray3[n] / dArray2[n];
            }
            for (n = n2 - 1; n > 0 && Utils.sm(dArray[n], dArray[n - 1]); --n) {
                this.m_Antds.removeElementAt(n);
            }
            if (this.m_Antds.size() == 1 && Utils.sm(dArray[0], d3 = (d2 = this.computeDefAccu(instances)) / d)) {
                this.m_Antds.removeAllElements();
            }
            if ((n = this.m_Antds.size()) != 0) {
                this.m_Worth = dArray3[n - 1];
                this.m_WorthRate = dArray[n - 1];
                this.m_CoverP = dArray2[n - 1];
                antd = (Antd)this.m_Antds.lastElement();
                this.m_CoverG = antd.getCover();
                this.m_AccuG = antd.getAccu();
            } else {
                this.m_Worth = d2;
                this.m_WorthRate = d3;
                this.m_CoverP = d;
            }
        }

        private double computeDefAccu(Instances instances) {
            double d = 0.0;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (!Utils.eq(instance.classValue(), this.m_Class)) continue;
                d += instance.weight();
            }
            return d;
        }

        public double getWorthRate() {
            return this.m_WorthRate;
        }

        public double getWorth() {
            return this.m_Worth;
        }

        public double getCoverP() {
            return this.m_CoverP;
        }

        public double getCoverG() {
            return this.m_CoverG;
        }

        public double getAccuG() {
            return this.m_AccuG;
        }

        public String toString(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int i = 0; i < this.m_Antds.size() - 1; ++i) {
                    stringBuffer.append("(" + ((Antd)this.m_Antds.elementAt(i)).toString() + ") and ");
                }
                stringBuffer.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            stringBuffer.append(" => " + string + " = " + string2);
            stringBuffer.append("  (" + this.m_CoverG + "/" + (this.m_CoverG - this.m_AccuG) + ") [" + this.m_CoverP + "/" + (this.m_CoverP - this.m_Worth) + "]");
            return stringBuffer.toString();
        }

        public String toString() {
            return this.toString(this.m_ClassAttribute.name(), this.m_ClassAttribute.value((int)this.m_Class));
        }
    }

    private class Ridor_node
    implements Serializable {
        static final long serialVersionUID = -581370560157467677L;
        private double defClass = Double.NaN;
        private RidorRule[] rules = null;
        private Ridor_node[] excepts = null;
        private int level;

        private Ridor_node() {
        }

        public double getDefClass() {
            return this.defClass;
        }

        public RidorRule[] getRules() {
            return this.rules;
        }

        public Ridor_node[] getExcepts() {
            return this.excepts;
        }

        public void findRules(Instances[] instancesArray, int n) throws Exception {
            Object object;
            int n2;
            Vector vector = null;
            int n3 = -1;
            double[] dArray = new double[instancesArray.length];
            int n4 = 0;
            this.level = n + 1;
            for (int i = 0; i < instancesArray.length; ++i) {
                dArray[i] = instancesArray[i].sumOfWeights();
                if (!Utils.grOrEq(dArray[i], Ridor.this.m_Folds)) continue;
                ++n4;
            }
            if (n4 <= 1) {
                this.defClass = Utils.maxIndex(dArray);
                return;
            }
            double d = Utils.sum(dArray);
            if (Ridor.this.m_IsMajority) {
                int n5;
                this.defClass = Utils.maxIndex(dArray);
                Instances instances = new Instances(instancesArray[(int)this.defClass]);
                n2 = instances.classIndex();
                for (n5 = 0; n5 < instances.numInstances(); ++n5) {
                    instances.instance(n5).setClassValue(1.0);
                }
                for (n5 = 0; n5 < instancesArray.length; ++n5) {
                    if (n5 == (int)this.defClass) continue;
                    instances = instances.numInstances() >= instancesArray[n5].numInstances() ? this.append(instances, instancesArray[n5]) : this.append(instancesArray[n5], instances);
                }
                instances.setClassIndex(n2);
                double d2 = d - dArray[(int)this.defClass];
                vector = new Vector();
                this.buildRuleset(instances, d2, vector);
                if (vector.size() == 0) {
                    return;
                }
            } else {
                double d3 = dArray[Utils.maxIndex(dArray)] / d;
                for (int i = 0; i < instancesArray.length; ++i) {
                    int n6;
                    if (!(dArray[i] >= (double)Ridor.this.m_Folds)) continue;
                    object = new Instances(instancesArray[i]);
                    int n7 = object.classIndex();
                    for (n6 = 0; n6 < object.numInstances(); ++n6) {
                        object.instance(n6).setClassValue(1.0);
                    }
                    for (n6 = 0; n6 < instancesArray.length; ++n6) {
                        if (n6 == i) continue;
                        object = object.numInstances() >= instancesArray[n6].numInstances() ? this.append((Instances)object, instancesArray[n6]) : this.append(instancesArray[n6], (Instances)object);
                    }
                    object.setClassIndex(n7);
                    double d4 = object.sumOfWeights() - dArray[i];
                    Vector vector2 = new Vector();
                    double d5 = this.buildRuleset((Instances)object, d4, vector2);
                    if (!Utils.gr(d5, d3)) continue;
                    vector = vector2;
                    d3 = d5;
                    n3 = i;
                }
                if (vector == null) {
                    this.defClass = Utils.maxIndex(dArray);
                    return;
                }
                this.defClass = n3;
            }
            int n8 = vector.size();
            this.rules = new RidorRule[n8];
            this.excepts = new Ridor_node[n8];
            for (n2 = 0; n2 < n8; ++n2) {
                this.rules[n2] = (RidorRule)vector.elementAt(n2);
            }
            Instances[] instancesArray2 = instancesArray;
            if (this.level == 1) {
                Ridor.this.m_Err = d - instancesArray2[(int)this.defClass].sumOfWeights();
            }
            instancesArray2[(int)this.defClass] = new Instances(instancesArray2[(int)this.defClass], 0);
            for (int i = 0; i < n8; ++i) {
                object = this.divide(this.rules[i], instancesArray2);
                Instances[] instancesArray3 = object[0];
                this.excepts[i] = new Ridor_node();
                this.excepts[i].findRules(instancesArray3, this.level);
            }
        }

        private double buildRuleset(Instances instances, double d, Vector vector) throws Exception {
            Instances instances2 = new Instances(instances);
            double d2 = 0.0;
            double d3 = instances2.sumOfWeights();
            while (d >= (double)Ridor.this.m_Folds) {
                double d4;
                RidorRule ridorRule = null;
                double d5 = -1.0;
                double d6 = -1.0;
                RidorRule ridorRule2 = new RidorRule();
                ridorRule2.setPredictedClass(0.0);
                for (int i = 0; i < Ridor.this.m_Shuffle; ++i) {
                    double d7;
                    if (Ridor.this.m_Shuffle > 1) {
                        instances2.randomize(Ridor.this.m_Random);
                    }
                    ridorRule2.buildClassifier(instances2);
                    if (Ridor.this.m_IsAllErr) {
                        d4 = (ridorRule2.getWorth() + ridorRule2.getAccuG()) / (ridorRule2.getCoverP() + ridorRule2.getCoverG());
                        d7 = ridorRule2.getWorth() + ridorRule2.getAccuG();
                    } else {
                        d4 = ridorRule2.getWorthRate();
                        d7 = ridorRule2.getWorth();
                    }
                    if (!Utils.gr(d4, d5) && (!Utils.eq(d4, d5) || !Utils.gr(d7, d6))) continue;
                    ridorRule = ridorRule2;
                    d5 = d4;
                    d6 = d7;
                }
                if (ridorRule == null) {
                    throw new Exception("Something wrong here inside findRule()!");
                }
                if (Utils.sm(d5, 0.5) || !ridorRule.hasAntds()) break;
                Instances instances3 = new Instances(instances2);
                instances2 = new Instances(instances3, 0);
                d = 0.0;
                d4 = 0.0;
                for (int i = 0; i < instances3.numInstances(); ++i) {
                    Instance instance = instances3.instance(i);
                    if (!ridorRule.isCover(instance)) {
                        instances2.add(instance);
                        if (!Utils.eq(instance.classValue(), 0.0)) continue;
                        d += instance.weight();
                        continue;
                    }
                    d4 += instance.weight();
                }
                d2 += this.computeWeightedAcRt(d5, d4, d3);
                vector.addElement(ridorRule);
            }
            double d8 = (instances2.sumOfWeights() - d) / d3;
            return d2 += d8;
        }

        private Instances append(Instances instances, Instances instances2) {
            Instances instances3 = new Instances(instances);
            for (int i = 0; i < instances2.numInstances(); ++i) {
                instances3.add(instances2.instance(i));
            }
            return instances3;
        }

        private double computeWeightedAcRt(double d, double d2, double d3) {
            return d * (d2 / d3);
        }

        private Instances[][] divide(RidorRule ridorRule, Instances[] instancesArray) {
            int n = instancesArray.length;
            Instances[][] instancesArray2 = new Instances[2][n];
            for (int i = 0; i < n; ++i) {
                Instances[] instancesArray3 = ridorRule.coveredByRule(instancesArray[i]);
                instancesArray2[0][i] = instancesArray3[0];
                instancesArray2[1][i] = instancesArray3[1];
            }
            return instancesArray2;
        }

        public int size() {
            int n = 0;
            if (this.rules != null) {
                for (int i = 0; i < this.rules.length; ++i) {
                    n += this.excepts[i].size();
                }
                n += this.rules.length;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.level == 1) {
                stringBuffer.append(Ridor.this.m_Class.name() + " = " + Ridor.this.m_Class.value((int)this.getDefClass()) + "  (" + Ridor.this.m_Cover + "/" + Ridor.this.m_Err + ")\n");
            }
            if (this.rules != null) {
                for (int i = 0; i < this.rules.length; ++i) {
                    for (int j = 0; j < this.level; ++j) {
                        stringBuffer.append("         ");
                    }
                    String string = Ridor.this.m_Class.value((int)this.excepts[i].getDefClass());
                    stringBuffer.append("  Except " + this.rules[i].toString(Ridor.this.m_Class.name(), string) + "\n" + this.excepts[i].toString());
                }
            }
            return stringBuffer.toString();
        }
    }
}

