/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class ExhaustiveSearch
extends ASSearch
implements OptionHandler {
    static final long serialVersionUID = 5741842861142379712L;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private boolean m_verbose;
    private int m_evaluations;

    public String globalInfo() {
        return "ExhaustiveSearch : \n\nPerforms an exhaustive search through the space of attribute subsets starting from the empty set of attrubutes. Reports the best subset found.";
    }

    public ExhaustiveSearch() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tOutput subsets as the search progresses.\n\t(default = false).", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setVerbose(Utils.getFlag('V', stringArray));
    }

    public String verboseTipText() {
        return "Print progress information. Sends progress info to the terminal as the search progresses.";
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String[] getOptions() {
        String[] stringArray = new String[1];
        int n = 0;
        if (this.m_verbose) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tExhaustive Search.\n\tStart set: ");
        stringBuffer.append("no attributes\n");
        stringBuffer.append("\tNumber of evaluations: " + this.m_evaluations + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        boolean bl = false;
        BigInteger bigInteger = BigInteger.ZERO;
        this.m_numAttribs = instances.numAttributes();
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)aSEvaluation;
        this.m_numAttribs = instances.numAttributes();
        double d = subsetEvaluator.evaluateSubset(this.m_bestGroup);
        ++this.m_evaluations;
        int n2 = this.countFeatures(this.m_bestGroup);
        BitSet bitSet = new BitSet(this.m_numAttribs);
        double d2 = subsetEvaluator.evaluateSubset(bitSet);
        if (this.m_verbose) {
            System.out.println("Zero feature subset (" + Utils.doubleToString(Math.abs(d2), 8, 5) + ")");
        }
        if (d2 >= d) {
            n = this.countFeatures(bitSet);
            if (d2 > d || n < n2) {
                d = d2;
                this.m_bestGroup = (BitSet)bitSet.clone();
                n2 = n;
            }
        }
        int n3 = this.m_hasClass ? this.m_numAttribs - 1 : this.m_numAttribs;
        BigInteger bigInteger2 = BigInteger.ONE.add(BigInteger.ONE).pow(n3).subtract(BigInteger.ONE);
        while (!bl) {
            if ((bigInteger = bigInteger.add(BigInteger.ONE)).equals(bigInteger2)) {
                bl = true;
            }
            bitSet.clear();
            for (int i = 0; i < n3; ++i) {
                if (!bigInteger.testBit(i)) continue;
                if (!this.m_hasClass) {
                    bitSet.set(i);
                    continue;
                }
                int n4 = i >= this.m_classIndex ? i + 1 : i;
                bitSet.set(n4);
            }
            d2 = subsetEvaluator.evaluateSubset(bitSet);
            ++this.m_evaluations;
            if (!(d2 >= d)) continue;
            n = this.countFeatures(bitSet);
            if (!(d2 > d) && n >= n2) continue;
            d = d2;
            this.m_bestGroup = (BitSet)bitSet.clone();
            n2 = n;
            if (!this.m_verbose) continue;
            System.out.println("New best subset (" + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
        }
        this.m_bestMerit = d;
        return this.attributeList(this.m_bestGroup);
    }

    private int countFeatures(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private String printSubset(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer.append(i + 1 + " ");
        }
        return stringBuffer.toString();
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private void generateNextSubset(int n, BitSet bitSet) {
        int n2;
        int n3 = 0;
        boolean bl = false;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        System.err.println("Size: " + n);
        for (n2 = 0; n2 < this.m_numAttribs; ++n2) {
            bitSet2.clear(n2);
        }
        block1: while (!bl && n3 < n) {
            for (n2 = this.m_numAttribs - 1 - n3; n2 >= 0; --n2) {
                if (!bitSet.get(n2)) continue;
                bitSet.clear(n2);
                if (n2 != this.m_numAttribs - 1 - n3) {
                    int n4 = n2 + 1;
                    if (n4 == this.m_classIndex) {
                        ++n4;
                    }
                    if (n4 < this.m_numAttribs) {
                        bitSet.set(n4);
                        for (int i = 0; i < n3; ++i) {
                            if (n4 + 1 + i == this.m_classIndex) {
                                ++n4;
                            }
                            if (n4 + 1 + i >= this.m_numAttribs) continue;
                            bitSet.set(n4 + 1 + i);
                        }
                        bl = true;
                        continue block1;
                    }
                    ++n3;
                    continue block1;
                }
                ++n3;
                continue block1;
            }
        }
        if (bitSet.cardinality() < n) {
            bitSet.clear();
        }
        System.err.println(this.printSubset(bitSet).toString());
    }

    private void resetOptions() {
        this.m_verbose = false;
        this.m_evaluations = 0;
    }
}

