/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.FileReader;
import java.io.Serializable;
import weka.classifiers.bayes.net.VaryNode;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class ADNode
implements Serializable {
    static final int MIN_RECORD_SIZE = 0;
    public VaryNode[] m_VaryNodes;
    public Instance[] m_Instances;
    public int m_nCount;
    public int m_nStartNode;

    public static VaryNode makeVaryNode(int n, FastVector fastVector, Instances instances) {
        int n2;
        int n3;
        int n4;
        VaryNode varyNode = new VaryNode(n);
        int n5 = instances.attribute(n).numValues();
        FastVector[] fastVectorArray = new FastVector[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            fastVectorArray[n4] = new FastVector();
        }
        for (n4 = 0; n4 < fastVector.size(); ++n4) {
            n3 = (Integer)fastVector.elementAt(n4);
            fastVectorArray[(int)instances.instance(n3).value(n)].addElement(new Integer(n3));
        }
        n4 = fastVectorArray[0].size();
        n3 = 0;
        for (n2 = 1; n2 < n5; ++n2) {
            if (fastVectorArray[n2].size() <= n4) continue;
            n4 = fastVectorArray[n2].size();
            n3 = n2;
        }
        varyNode.m_nMCV = n3;
        varyNode.m_ADNodes = new ADNode[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            varyNode.m_ADNodes[n2] = n2 == n3 || fastVectorArray[n2].size() == 0 ? null : ADNode.makeADTree(n + 1, fastVectorArray[n2], instances);
        }
        return varyNode;
    }

    public static ADNode makeADTree(int n, FastVector fastVector, Instances instances) {
        ADNode aDNode = new ADNode();
        aDNode.m_nCount = fastVector.size();
        aDNode.m_nStartNode = n;
        if (fastVector.size() < 0) {
            aDNode.m_Instances = new Instance[fastVector.size()];
            for (int i = 0; i < fastVector.size(); ++i) {
                aDNode.m_Instances[i] = instances.instance((Integer)fastVector.elementAt(i));
            }
        } else {
            aDNode.m_VaryNodes = new VaryNode[instances.numAttributes() - n];
            for (int i = n; i < instances.numAttributes(); ++i) {
                aDNode.m_VaryNodes[i - n] = ADNode.makeVaryNode(i, fastVector, instances);
            }
        }
        return aDNode;
    }

    public static ADNode makeADTree(Instances instances) {
        FastVector fastVector = new FastVector(instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            fastVector.addElement(new Integer(i));
        }
        return ADNode.makeADTree(0, fastVector, instances);
    }

    public void getCounts(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, boolean bl) {
        if (n >= nArray2.length) {
            if (bl) {
                int n3 = n2;
                nArray[n3] = nArray[n3] - this.m_nCount;
            } else {
                int n4 = n2;
                nArray[n4] = nArray[n4] + this.m_nCount;
            }
            return;
        }
        if (this.m_VaryNodes != null) {
            this.m_VaryNodes[nArray2[n] - this.m_nStartNode].getCounts(nArray, nArray2, nArray3, n, n2, this, bl);
        } else {
            for (int i = 0; i < this.m_Instances.length; ++i) {
                int n5 = n2;
                Instance instance = this.m_Instances[i];
                for (int j = n; j < nArray2.length; ++j) {
                    n5 += nArray3[j] * (int)instance.value(nArray2[j]);
                }
                if (bl) {
                    int n6 = n5;
                    nArray[n6] = nArray[n6] - 1;
                    continue;
                }
                int n7 = n5;
                nArray[n7] = nArray[n7] + 1;
            }
        }
    }

    public void print() {
        int n;
        String string = new String();
        for (n = 0; n < this.m_nStartNode; ++n) {
            string = string + "  ";
        }
        System.out.println(string + "Count = " + this.m_nCount);
        if (this.m_VaryNodes != null) {
            for (n = 0; n < this.m_VaryNodes.length; ++n) {
                System.out.println(string + "Node " + (n + this.m_nStartNode));
                this.m_VaryNodes[n].print(string);
            }
        } else {
            System.out.println(this.m_Instances);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Instances instances = new Instances(new FileReader("\\iris.2.arff"));
            ADNode aDNode = ADNode.makeADTree(instances);
            int[] nArray = new int[12];
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 3;
            nArray2[2] = 4;
            nArray3[0] = 2;
            nArray3[1] = 1;
            nArray3[2] = 4;
            aDNode.print();
            aDNode.getCounts(nArray, nArray2, nArray3, 0, 0, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

