% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_start_of_line}
\alias{rx_start_of_line}
\title{Match the expression only if it appears from beginning of line.}
\usage{
rx_start_of_line(.data = NULL, enable = TRUE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{enable}{Whether to enable this behavior, defaults to \code{TRUE}}
}
\description{
Control whether to match the expression only if it appears from
the beginning of the line.
}
\examples{
rx_start_of_line(enable = TRUE)
rx_start_of_line(enable = FALSE)

# create expression
x <- rx() \%>\%
  rx_start_of_line() \%>\%
  rx_find("apple")

grepl(x, "pineapple") # should be false
grepl(x, "apple")     # should be true
}
