% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_something_but}
\alias{rx_something_but}
\title{Match any character(s) except these at least once.}
\usage{
rx_something_but(.data = NULL, value, mode = "greedy")
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Expression to optionally match}

\item{mode}{Matching mode (\code{greedy} (default) or\code{lazy}). \code{Lazy} matching stops after the first match, \code{greedy} continues
searching until end of the string and then back-tracks to the last match.}
}
\description{
This expression is almost identical to \code{rx_anything_but()}
with one major exception, a \code{+} is used instead of a \code{*}. This
means \code{rx_something_but()} expects \emph{something} whereas
\code{rx_anything_but()} expects \emph{anything} including... nothing!
}
\examples{
rx_something_but(value = "abc")

# create an expression
x <- rx_something_but(value = "python")

grepl(x, "R")  # should be true
grepl(x, "py") # should be false

}
\references{
Metacharacters: \url{https://www.regular-expressions.info/characters.html#special}

Greedy and Lazy Quantifiers: \url{https://www.regular-expressions.info/repeat.html#greedy}
}
