% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_either_of}
\alias{rx_either_of}
\title{Alternatively, match either expression.}
\usage{
rx_either_of(.data, ...)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{...}{A character vector}
}
\description{
Expression to match instead. If both expressions exists, both
will be returned. This just adds the vertical bar \code{|} often called an
\emph{alternator} which allows the user to find this \emph{or} that, or both!
}
\examples{
x <- rx() \%>\%
  rx_either_of("cat", "dog") \%>\%
  rx_space() \%>\%
  rx_find("food")

string <- c("dog food", "cat food", "fish food")

grep(x, string, value = TRUE)
}
