% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.weights.R
\name{compute.weights}
\alias{compute.weights}
\title{Compute/create matrix with genotype weights}
\usage{
compute.weights(G, weights)
}
\arguments{
\item{G}{matrix of genotypes (genetic variants as columns,
individuals as rows) as output by the \code{\link{Get.G}}
function.}

\item{weights}{optional numeric vector of genotype weights. If
this option is not specified, the beta distribution is used
for weighting the variants, with each weight given by
\eqn{w_i = dbeta(f_i, 1, 25)^2}, with \eqn{f_i} the minor
allele frequency (MAF) of variant \eqn{i}. This default is the
same as used by the
\href{https://cran.r-project.org/package=SKAT}{\code{SKAT}
package}. This vector is used as the diagonal of the
\eqn{m \times m} matrix \eqn{W}, with \eqn{m} the number of
variants.}
}
\value{
Matrix with genotype weights.
}
\description{
Compute/create matrix with genotype weights
}
\details{
If the \code{weights} parameter (a numeric vector) is given, this
    function will return a matrix with that vector as the
    diagonal. If the \code{weights} parameter is not given (equal
    to \code{NULL}) the genotype weights will be calculated using
    the beta distribution (see the explanation of the
    \code{weights} parameter).
}
\author{
Karim Oualkacha, Lennart C. Karssen
}
\keyword{internal}

