% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast.R
\name{transForecast}
\alias{transForecast}
\title{Forecast - using Credit Cycle}
\usage{
transForecast(genMat, creditIndex)
}
\arguments{
\item{genMat}{Generator Matrix}

\item{creditIndex}{a credit index.  The model relies on the assumption that credit migration matrices are driven by
a single parameter Z, which depicts the average financial health of corporate institutions (credit index). The degree
of 'shift' corresponds to a simple change in the transition probabilities from an average average matrix.}
}
\value{
The output consists of a forecasted (shifted) transition matrix.
}
\description{
This model implements the One-Parameter Representation method developed by Forest, Belkin and Suchower.
}
\details{
The Vasicek (1987) Single Factor moodel \eqn{A_i = \sqrt{\rho_i}Z + \sqrt{1-\rho_i}\epsilon} presents a framework which Forest, Belkin
and Suchower (1998) used to developed the One-Parameter Representation method. In that model, migration behaviors are described
standard normal variables instead of transition probabilities without the loss of information. The transition through probabilites
are transformed to thresholds where the upper and lower bounds of the threshold values together represent bins. Therefore, when
a random variable falls within a particular bin that signifies a transition to the corresponding transition rating bucket.

The advantage of representing transitions probabilities in terms of the threshold framework is that we can
now use the standard normal density curve to understand the behavior rating transitions.  The area under a
standard normal curve between the lower and upper bounds of a thresholds for a particular bin is the transition probability.
Therefore in the context of economic conditions, the shifting of curves (to the left or the right) under static
thresholds, informs us about the behavior of transitions matrices during benign and stressed periods.

To the extent that we can represent economic conditions with a single variable, we can 'shift' the average
transition matrix by this amount to generate a forecast of the transition matrix.

See Forest, Belkin and Suchower (1998) for a more detailed discussion
}
\examples{

#Use the function 'TransitionProb' to estimate an annualized transition matrix which will
#then be used along with the appropriate creditIndex to forecast future period migration
#effects.


snapshots <- 4    #This uses quarterly transition matrices
interval <- 1    #This gives a 1 year transition matrix
startDate  <- "2000-01-01"
endDate    <- "2005-01-01"
Example9<-TransitionProb(data,startDate, endDate,'duration', snapshots, interval)
Example9.1 <- Example9$genMat
creditIndex <- -0.25


Example10 <- transForecast(Example9.1, creditIndex)


}
\author{
Abdoulaye (Ab) N'Diaye

Loffler, G., P. N. Posch. 2007 Credit Risk Modeling Using Excel and VBA.
West Sussex, England, Wiley Finance

L. R. Forest, B. Belkin, and S. J. Suchower, 1998 A One-Parameter Representation of Credit Risk and Transition Matrices,
CreditMetrics Monitor. Q3

Vasicek, O., 1987 Probability of loss on a loan portfolio. Working paper, KMV.
}
