% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRROption.R
\name{CRROption}
\alias{CRROption}
\title{Cox-Ross-Rubinstein Option Pricing Model}
\usage{
CRROption(S, X, sigma, r, b, T2M, N, type, optionStyle)
}
\arguments{
\item{S}{Numeric, the current stock price (also known as the underlying asset price).}

\item{X}{Numeric, the strike price of the option.}

\item{sigma}{Numeric, the implied volatility of the underlying stock (annualized).}

\item{r}{Numeric, the risk-free interest rate (annualized).}

\item{b}{Numeric, the cost of carry, b = r - q for dividend paying assets, where q is the dividend yield rate.}

\item{T2M}{Numeric, the time to maturity of the option (in years).}

\item{N}{Integer, the number of time steps in the binomial tree.}

\item{type}{Character, the type of option ("call" or "put").}

\item{optionStyle}{Character, the style of the option ("european" or "american").}
}
\value{
A list containing the computed price of the option and a note indicating if the model is suitable for the provided parameters.
}
\description{
Computes the price of European and American options using the Cox-Ross-Rubinstein binomial model.
This function is optimized for performance and implemented in C++. Haug (2007) provides a detailed description of the model.
}
\examples{
# CRROption(S = 100, X = 100, sigma = 0.25, r = 0.1, b = 0, T2M = 1, N = 500,
# type = "call", optionStyle = "european")
# CRROption(S = 100, X = 100, sigma = 0.25, r = 0.1, b = 0, T2M = 1, N = 500,
# type = "call", optionStyle = "american")

}
