% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGBM.R
\name{simGBM}
\alias{simGBM}
\title{GBM process simulation}
\usage{
simGBM(
  nsims = 1,
  S0 = 10,
  drift = 0,
  sigma = 0.2,
  T2M = 1,
  dt = 1/12,
  vec = TRUE
)
}
\arguments{
\item{nsims}{number of simulations. Defaults to 1. \code{numeric}}

\item{S0}{Spot price at t=0. \code{numeric}}

\item{drift}{Drift term in percentage. \code{numeric}}

\item{sigma}{Standard deviation. \code{numeric}}

\item{T2M}{Maturity in years. \code{numeric}}

\item{dt}{Time step in period e.g. 1/250 = 1 business day. \code{numeric}}

\item{vec}{Vectorized implementation. Defaults to TRUE. \code{logical}}
}
\value{
A tibble of simulated values. \code{tibble}
}
\description{
Simulates a Geometric Brownian Motion process
}
\examples{
simGBM(nsims = 2, S0 = 10, drift = 0, sigma = 0.2, T2M = 1, dt = 1 / 12, vec = TRUE)
}
\author{
Philippe Cote
}
