% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promptBeta.R
\name{promptBeta}
\alias{promptBeta}
\title{\code{promptBeta}}
\usage{
promptBeta(x = x, period = "all", betatype = "all", output = "chart")
}
\arguments{
\item{x}{Wide dataframe with date column and multiple series columns (multivariate).}

\item{period}{"all" or numeric period of time in last n periods as character eg "100".}

\item{betatype}{"all" "bull" "bear".}

\item{output}{"betas" or "chart"}
}
\value{
betas data frame or plotly chart of betas
}
\description{
Returns betas of futures contracts versus front futures contract.
}
\examples{
\dontrun{
x <- dflong \%>\% dplyr::filter(grepl("CL",series))
x <- x \%>\% dplyr::mutate(series = readr::parse_number(series)) \%>\% dplyr::group_by(series)
x <- RTL::returns(df = x,retType = "abs",period.return = 1,spread = TRUE)
x <- RTL::rolladjust(x = x,commodityname = c("cmewti"),rolltype = c("Last.Trade"))
x <- x \%>\% dplyr::filter(!grepl("2020-04-20|2020-04-21",date))
promptBeta(x = x,period = "all",betatype = "all",output = "chart")
promptBeta(x = x,period = "all",betatype = "all",output = "betas")
promptBeta(x = x,period = "100",betatype = "all",output = "betas")
}
}
\author{
Philippe Cote
}
