% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolladjust.R
\name{rolladjust}
\alias{rolladjust}
\title{\code{rolladjust}}
\usage{
rolladjust(x, commodityname = c("cmewti"), rolltype = c("Last.Trade"), ...)
}
\arguments{
\item{x}{An xts object of prices or returns.}

\item{commodityname}{Name of commodity in expiry_table. See example below for values.}

\item{rolltype}{Type of contract roll: "Last.Trade" or "First.Notice".}

\item{...}{Other parms}
}
\value{
Roll-adjusted xts object of returns
}
\description{
Returns a xts price or return object adjusted for contract roll. The methodology used to adjust returns is to remove the daily returns on the day after expiry and for prices to adjust historical rolling front month contracts by the size of the roll at each expiry. This is conducive to quantitative trading strategies as it reflects the PL of a financial trader.
}
\examples{
unique(expiry_table$cmdty) # for list of commodity names
ret <- returns(df=dflong,retType="abs",period.return=1,spread=TRUE)[,1:2] 
rolladjust(x=ret,commodityname=c("cmewti"),rolltype=c("Last.Trade"))
}
\author{
Philippe Cote
}
