% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvalFunction.R
\name{EvalFunction}
\alias{EvalFunction}
\title{Parse and Evaluate an RSurvey Expression}
\usage{
EvalFunction(txt, cols)
}
\arguments{
\item{txt}{character.
A string representation of an \R function.}

\item{cols}{list.
See \code{\link{ManageVariables}}}
}
\value{
Returns the result of evaluating the text expression.
}
\description{
This function parses and evaluates a character string representation of an \pkg{RSurvey} expression.
}
\examples{
d <- list(x = 1:10, y = 10:1)
Data("data.raw", d)
cols <- list()
cols[[1]] <- list(id = "X", index = 1, fun = "\\"X\\"")
cols[[2]] <- list(id = "Y", index = 2, fun = "\\"Y\\"")
EvalFunction("\\"Y\\"", cols)
EvalFunction("\\"X\\" + \\"Y\\"", cols)
EvalFunction("rnorm(12)", cols)

}
\seealso{
\code{\link{parse}}, \code{\link{eval}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
