% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tp.normal}
\alias{tp.normal}
\title{Normal approximation confidence limits for true prevalence}
\usage{
tp.normal(x, n, se, sp, conf = 0.95)
}
\arguments{
\item{x}{number of positive results in sample (scalar or vector)}

\item{n}{sample size (scalar or vector)}

\item{se}{test unit sensitivity (scalar or vector)}

\item{sp}{test unit specificity (scalar or vector)}

\item{conf}{desired level of confidence for CI, default = 0.95 (scalar or vector)}
}
\value{
list with 2 elements, a matrix of apparent prevalence and wilson lower and upper confidence limits
and a matrix of true prevalence and normal approximation lower and upper confidence limits
}
\description{
Estimates true prevalence and confidence limits for
estimates based on normal approximation
}
\examples{
# examples for tp.normal
tp.normal(25, 120, 0.9, 0.99)
tp.normal(seq(5, 25, by=5), 120, 0.9, 0.99)
}
\keyword{methods}

