% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_lock_env}
\alias{prj_lock_env}
\title{Locks the project environment.}
\usage{
prj_lock_env(prj = NULL)
}
\arguments{
\item{prj}{project object to be locked. If not passed will lock loaded
project or default whichever exists. Will init default project from
working directory if no default project exists.
(type: rsuite_project, default: NULL)}
}
\description{
It collects all dependencies' versions and stores them in lock file to
enforce exact dependency versions in the future.
}
\details{
The lock file is saved in <my_project>/deployment/ under 'env.lock' name.
It is in dcf format with information about packages installed in local
project environment together with their versions. A sample record from
the lock file:

 Package: RSuite\cr
 Version: 0.26.235

When dependencies are being installed (using \code{\link{prj_install_deps}})
the 'env.lock' file will be used to detect whether any package will change
versions. If that's the case a warning message will be displayed like this:

\code{...:rsuite: The following packages will be updated from last lock: colorspace}

The feature allows preventing errors caused by newer versions of packages
which might work differently than previous versions used in the project.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# build project local environment
prj_install_deps(prj = prj)

# lock project environment
prj_lock_env(prj = prj)

# present contents of lock file created
cat(readLines(file.path(prj$path, "deployment", "env.lock")), sep = "\\n")

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_pack}}, \code{\link{prj_start_package}},
  \code{\link{prj_start}}, \code{\link{prj_unload}},
  \code{\link{prj_zip}}
}
