% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfers.R
\name{stripe_create_transfer}
\alias{stripe_create_transfer}
\title{Create a transfer to Stripe.}
\usage{
stripe_create_transfer(api_key, args)
}
\arguments{
\item{api_key}{Your Stripe API Key}

\item{args}{A list of arguments
\describe{
   \item{amount}{\strong{required} Amount for transfer.}
   \item{currency}{\strong{required} The 3-letter currency.}
   \item{recipient}{\strong{required} The recipient id of the transfer.}
   \item{description}{\emph{optional} The description of the transfer.}
   \item{metadata}{\emph{optional} A list which can contain anything to further describe.}
   \item{bank_account}{\emph{optional} The bank to transfer money to.  Include this, card,
                       or neither.}
   \item{card}{\emph{optional} The card to transfer the money to. Include either Bank Account
               Card, or neither.}
   \item{statement_description}{\emph{optional} 15 character description to appear on
                                statement.}
}}
}
\value{
A data frame with transfer information
}
\description{
Create a new transfer that will be first marked as pending.
}

