% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoMethods.R
\name{getSauceLabsStatus}
\alias{getSauceLabsStatus}
\title{Get Sauce Labs Status}
\usage{
getSauceLabsStatus(account, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Get the current status of Sauce Labs services
}
\examples{
\dontrun{
myAcc <- account()
getSauceLabsStatus(myAcc)
#$wait_time
#[1] 1580.536
#
#$service_operational
#[1] TRUE
#
#$status_message
#[1] "Basic service status checks passed."
supportedPlatforms <- getSupportedPlatforms(myAcc)
supportedPlatforms[os == "Linux" & api_name == "chrome" & short_version > 44
                   , .(api_name, long_version)]
#api_name  long_version
#1:   chrome 45.0.2454.85.
#2:   chrome  46.0.2490.71
#3:   chrome  47.0.2526.73
#4:   chrome  48.0.2564.97
getAppiumEolDates(myAcc)
#$`1.4.0`
#[1] "2016-04-09 PDT"
#
#$`1.4.3`
#[1] "2016-04-09 PDT"
#....
}
}
\seealso{
Other infoMethods: \code{\link{getAppiumEolDates}},
  \code{\link{getSupportedPlatforms}}
}

