% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_smet.R
\docType{class}
\name{smet-class}
\alias{smet-class}
\title{smet-class}
\description{
Class \code{smet}
}
\details{
This class represents the SMET format file for weather station data 
 \describe{
    \item{\code{signature}:}{A charachter string containing SMET signature}

\item{\code{header}:}{Object of class \code{"list"} containing the Header Section, each key corresponds to a component of the list.    }
    \item{\code{data}:}{S3 Object of class \code{"data.frame"} containing the weather data values. Date field is often alled \code{"timestamp"} and written in \code{\link{POSIXlt}} format. }

\item{\code{file}:}{full name of the SMET file. If it is missing, it is \code{NA}.}
 }

Detailed information about SMET format is reminded to \url{http://models.slf.ch/docserver/meteoio/SMET_specifications.pdf}.
}
\examples{

showClass("smet")

as.smet("test")

}
\author{
Emanuele Cordano
}
\references{
\url{http://models.slf.ch/docserver/meteoio/html/smetio.html} or \url{http://models.slf.ch/docserver/meteoio/SMET_specifications.pdf}


#' @note A \code{SMET-class} object can be created by a SMET file trough \code{\link{smet}} or can be coerced from another type object through \code{\link{as.smet}}.
or returned by the function \code{\link{smet}}
}
\seealso{
\code{\link{smet}},\code{\link{as.smet}},\code{\link{print.smet}}

\code{\link{smet-class}}
}
\keyword{classes}

