% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.predict.R
\name{sym.predict}
\alias{sym.predict}
\alias{sym.predict.symbolic_lm_cm}
\alias{sym.predict.symbolic_lm_crm}
\alias{sym.predict.symbolic_glm_cm}
\title{Predict method to CM and CRM Linear regression model}
\usage{
sym.predict(model, ...)

\method{sym.predict}{symbolic_lm_cm}(model, new.sym.data, ...)

\method{sym.predict}{symbolic_lm_crm}(model, new.sym.data, ...)

\method{sym.predict}{symbolic_glm_cm}(model, new.sym.data, response, ...)
}
\arguments{
\item{model}{The output of lm method.}

\item{...}{additional arguments affecting the predictions produced.}

\item{new.sym.data}{Should be a symbolic data table read with the function read.sym.table(...).}

\item{response}{The number of the column where is the response variable in the interval data table.}
}
\value{
sym.predict produces a vector of predictions or a matrix of predictions and bounds
with column names fit, lwr, and upr if interval is set. For type = 'terms' this is a
matrix with a column per term and may have an attribute 'constant'
}
\description{
To execute predict method the Center Method (CR) and Center and Range Method (CRM) to
Linear regression.
}
\examples{
data(int_prost_train)
data(int_prost_test)
model <- sym.lm(lpsa ~ ., sym.data = int_prost_train, method = "cm")
pred.cm <- sym.predict(model, int_prost_test)
pred.cm
}
\references{
LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2008). Centre and range method
to fitting a linear regression model on symbolic interval data. Computational
Statistics and Data Analysis 52, 1500-1515.

LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2010). Constrained linear regression models
for symbolic interval-valued variables. Computational Statistics and
Data Analysis 54, 333-347.
}
\seealso{
sym.glm
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{lm}
