/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.util;

import com.dashoptimization.XPRM;
import com.dashoptimization.XPRMCompileException;
import com.dashoptimization.XPRMModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Xprm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xprm.class);
    private static final XPRM INSTANCE = new XPRM();
    private static final String BIM_FILE_PATH;
    private static final String MOS_FILE_PATH = "org/act/mosel/shadow_test.mos";

    private Xprm() {
    }

    public static XPRMModel newModel() throws IOException {
        return INSTANCE.loadModel(BIM_FILE_PATH);
    }

    private static void compile(String sourcePath, String destPath) throws XPRMCompileException {
        INSTANCE.compile(null, sourcePath, destPath);
    }

    private static String compileBIM(String sourceFileResource) throws IOException {
        File tempFile = File.createTempFile("model", ".mos");
        tempFile.deleteOnExit();
        ClassLoader classLoader = Xprm.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(sourceFileResource);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)tempFile);
        String outputPath = tempFile.getPath().replaceFirst("mos", "bim");
        try {
            Xprm.compile(tempFile.getPath(), outputPath);
        }
        catch (XPRMCompileException e) {
            LOGGER.error("Exception compiling BIM", (Throwable)e);
        }
        return outputPath;
    }

    static {
        try {
            BIM_FILE_PATH = Xprm.compileBIM(MOS_FILE_PATH);
        }
        catch (IOException e) {
            String message = "Exception loading BIM from path:org/act/mosel/shadow_test.mos";
            throw new IllegalStateException(message, e);
        }
    }
}

