% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.rsa.R
\name{best.rsa}
\alias{best.rsa}
\title{Compare a list of polynomial models against the data}
\usage{
best.rsa(RSA_object, order = c("wAIC", "R2adj"), robust = TRUE)
}
\arguments{
\item{RSA_object}{x an object of class "RSA_object" generated by RSAmodel()}

\item{order}{Single or vector of fit indices used to determine best-fitting polynomial families. The output matrix is ordered based on this fit index}

\item{robust}{Should robust fit indices should be extracted? (default= TRUE)}
}
\value{
A table containing fit indices for each model
}
\description{
Compares any number of predefined or user-specific polynomial models and extracts their fit indices, thereby establishing best-fitting solutions.
}
\details{
This function compares models based on information-theoretic criteria and statistical tests. The cubic saturated polynomial provides a benchmark reference for fit, against which predefined polynomial families (37 to date) or user-specific variants of these families are compared for absolute fit (likelihood ratio test), parsimony (wAIC), explained variance (adjusted R2), and ordinary SEM criteria (e.g., CFI, TLI, RMSEA, SRMR).
}
\examples{
#####ESTIMATE RSA OBJECT
RSA_step1 <-  RSAmodel(engagement ~ needs*supplies,
data= sim_NSfit, model= c("CUBIC","FM8_INCONG","FM9_INCONG","FM20_ASYMCONG",
"FM21_ASYMCONG","FM26_PARALLELASYMWEAK"))
##### COMPARE POLYNOMIAL FAMILIES FROM THE RSA OBJECT
RSA_step1_fit <- best.rsa(RSA_step1,order=c("wAIC"))
names(RSA_step1$models)
#Inspect best-fitting family model
summary(RSA_step1$models$FM26_PARALLELASYMWEAK)
}
