% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.filter.simple}
\alias{rsaga.filter.simple}
\title{Simple Filters}
\usage{
rsaga.filter.simple(in.grid, out.grid, mode = "circle", method = c("smooth",
  "sharpen", "edge"), radius, env = rsaga.env(), ...)
}
\arguments{
\item{in.grid}{input: SAGA grid file (default file extension: \code{.sgrd})}

\item{out.grid}{output: SAGA grid file}

\item{mode}{character or numeric: shape of moving window, either \code{"square"} (=0) or \code{"circle"} (=1, default)}

\item{method}{character or numeric: \code{"smooth"} (=0), \code{"sharpen"} (=1), or \code{"edge"} (=2)}

\item{radius}{positive integer: radius of moving window}

\item{env}{list, setting up a SAGA geoprocessing environment as created by \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}, including the \code{env} RSAGA geoprocessing environment}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (the default) a character vector with the module's console output.
}
\description{
Apply a smoothing, sharpening or edge filter to a SAGA grid.
}
\examples{
\dontrun{rsaga.filter.simple("dem","dem-smooth",radius=4)}
}
\seealso{
\code{\link[=rsaga.filter.gauss]{rsaga.filter.gauss()}}
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA module)
}
\keyword{interface}
\keyword{spatial}
