% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizedsubtree.R
\name{sizedsubtree}
\alias{sizedsubtree}
\title{Find a node subtending to a clade of desired size}
\usage{
sizedsubtree(tree,Size=NULL,time.limit=10)
}
\arguments{
\item{tree}{a phylogenetic tree.}

\item{Size}{the desired size of the tree subtending to the extracted node. By
default, the minimum tree size is set at one tenth of the tree size (i.e.
number of tips).}

\item{time.limit}{specifies a limit to the searching time, a warning message
is thrown if the limit is reached.}
}
\value{
A node subtending to a subtree of desired minimum size.
}
\description{
The function \code{sizedsubtree} scans a phylogentic tree to
  randomly find nodes subtending to a subtree of desired minimum size, up to
  one half of the tree size (number of tips).
}
\details{
The argument \code{time.limit} sets the searching time. The
  algorithm stops if that limit is reached, avoiding recursive search when no
  solution is in fact possible.
}
\examples{
 \dontrun{
 data("DataOrnithodirans")
 DataOrnithodirans$treedino->treedino
 sizedsubtree(tree=treedino,Size=40)->sst
}
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
  Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
  Carotenuto
}
