% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_options}
\alias{get_options}
\title{Get options of parameters for a specific GIS option}
\usage{
get_options(alg = NULL, qgis_env = set_env(), intern = FALSE)
}
\arguments{
\item{alg}{Name of the GIS function for which options should be
returned.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}

\item{intern}{Logical which indicates whether to capture the output of the
command as an \code{R} character vector (see also
\code{\link[base]{system}}.}
}
\description{
\code{get_options} lists all available parameter options for
  the required GIS function.
}
\details{
Function \code{get_options} simply calls
  \code{processing.algoptions} using Python.
}
\examples{
\dontrun{
get_options(alg = "saga:slopeaspectcurvature")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

