% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PqResult.R
\docType{methods}
\name{postgres-query}
\alias{postgres-query}
\alias{dbSendQuery,PqConnection,character-method}
\alias{dbFetch,PqResult-method}
\alias{dbBind,PqResult-method}
\alias{dbHasCompleted,PqResult-method}
\alias{dbClearResult,PqResult-method}
\title{Execute a SQL statement on a database connection}
\usage{
\S4method{dbSendQuery}{PqConnection,character}(conn, statement, params = NULL,
  ...)

\S4method{dbFetch}{PqResult}(res, n = -1, ..., row.names = FALSE)

\S4method{dbBind}{PqResult}(res, params, ...)

\S4method{dbHasCompleted}{PqResult}(res, ...)

\S4method{dbClearResult}{PqResult}(res, ...)
}
\arguments{
\item{conn}{A \linkS4class{PqConnection} created by \code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{An SQL string to execute}

\item{params}{A list of query parameters to be substituted into
a parameterised query. Query parameters are sent as strings, and the
correct type is imputed by PostgreSQL. If this fails, you can manually
cast the parameter with e.g. \code{"$1::bigint"}.}

\item{...}{Another arguments needed for compatibility with generic (
currently ignored).}

\item{res}{Code a \linkS4class{PqResult} produced by
\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}.}

\item{n}{Number of rows to return. If less than zero returns all rows.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}
}
\description{
To retrieve results a chunk at a time, use \code{dbSendQuery()},
\code{dbFetch()}, then \code{dbClearResult()}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{dbGetQuery()} which sends,
fetches and clears for you.
}
\examples{
# For running the examples on systems without PostgreSQL connection:
run <- postgresHasDefault()

library(DBI)
if (run) db <- dbConnect(RPostgres::Postgres())
if (run) dbWriteTable(db, "usarrests", datasets::USArrests, temporary = TRUE)

# Run query to get results as dataframe
if (run) dbGetQuery(db, "SELECT * FROM usarrests LIMIT 3")

# Send query to pull requests in batches
if (run) res <- dbSendQuery(db, "SELECT * FROM usarrests")
if (run) dbFetch(res, n = 2)
if (run) dbFetch(res, n = 2)
if (run) dbHasCompleted(res)
if (run) dbClearResult(res)

if (run) dbRemoveTable(db, "usarrests")

if (run) dbDisconnect(db)
}
