% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IF_VaRratio.R
\name{IF.VaRratio}
\alias{IF.VaRratio}
\title{Influence Function - Value at Risk (VaR) Ratio}
\usage{
IF.VaRratio(
  returns = NULL,
  evalShape = FALSE,
  retVals = NULL,
  nuisPars = NULL,
  k = 4,
  IFplot = FALSE,
  IFprint = TRUE,
  alpha = 0.05,
  rf = 0,
  prewhiten = FALSE,
  ar.prewhiten.order = 1,
  cleanOutliers = FALSE,
  cleanMethod = c("locScaleRob", "Boudt")[1],
  eff = 0.99,
  alpha.robust = 0.05,
  ...
)
}
\arguments{
\item{returns}{Returns data of the asset or portfolio. This can be a numeric or an xts object.}

\item{evalShape}{Evaluation of the shape of the IF risk or performance measure if TRUE. Otherwise, a TS of the IF of the provided returns is computed.}

\item{retVals}{Values used to evaluate the shape of the IF.}

\item{nuisPars}{Nuisance parameters used for the evaluation of the shape of the IF (if no returns are provided).}

\item{k}{Range parameter for the shape of the IF (the SD gets multiplied k times).}

\item{IFplot}{If TRUE, the plot of the IF shape or IF TS of the returns is produced.}

\item{IFprint}{If TRUE, the data for the IF shape or the IF TS of the returns is returned.}

\item{alpha}{The tail probability of interest.}

\item{rf}{Risk-free interest rate.}

\item{prewhiten}{Boolean variable to indicate if the IF TS is pre-whitened (TRUE) or not (FALSE).}

\item{ar.prewhiten.order}{Order of AR parameter for the pre-whitening. Default is AR(1).}

\item{cleanOutliers}{Boolean variable to indicate whether outliers are cleaned with a robust location and scale estimator.}

\item{cleanMethod}{Robust method used to clean outliers from the TS. The choices are "locScaleRob" (default) and "Boudt" for the function.}

\item{eff}{Tuning parameter for the normal distribution efficiency for the "locScaleRob" robust data cleaning.}

\item{alpha.robust}{Tuning parameter for the quantile of the "Boudt" robust data cleaning algorithm, using the minimum covariance determinant estimator (MCD).}

\item{...}{Additional parameters.}
}
\value{
Influence function of the VaRratio.
}
\description{
\code{IF.VaRratio} returns the data and plots the shape of either the IF or the IF TS for the VaR Ratio.
}
\details{
For further details on the usage of the \code{nuisPars} argument, please refer to Section 3.1 for the \code{RPEIF} vignette.
}
\examples{
# Plot of IF with nuisance parameter with return value
outIF <- IF.VaRratio(returns=NULL, evalShape=TRUE, 
                     retVals=NULL, nuisPars=NULL,
                     IFplot=TRUE, IFprint=TRUE)

data(edhec, package="PerformanceAnalytics")
colnames(edhec) = c("CA", "CTAG", "DIS", "EM","EMN", "ED", "FIA",
                    "GM", "LS", "MA", "RV", "SS", "FoF") 

# Plot of IF a specified TS 
outIF <- IF.VaRratio(returns=edhec[,"CA"], evalShape=TRUE, 
                     retVals=seq(-0.1, 0.1, by=0.001), nuisPars=NULL,
                     IFplot=TRUE, IFprint=TRUE)

# Computing the IF of the returns (with outlier cleaning and prewhitening) with a plot of IF TS
outIF <- IF.VaRratio(returns=edhec[,"CA"], evalShape=FALSE, 
                     retVals=NULL, nuisPars=NULL,
                     IFplot=TRUE, IFprint=TRUE,
                     prewhiten=FALSE,
                     cleanOutliers=TRUE, cleanMethod=c("locScaleRob", "Boudt")[1], eff=0.99)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
