% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{L_objective}
\alias{L_objective}
\alias{terms.L_objective}
\alias{as.L_objective}
\alias{variable.names.L_objective}
\title{Linear Objective Function}
\usage{
L_objective(L, names = NULL)

\method{terms}{L_objective}(x, ...)

as.L_objective(x)

\method{variable.names}{L_objective}(object, ...)
}
\arguments{
\item{L}{a numeric vector of length \eqn{n} or an object of class
\code{"simple_triplet_matrix"} (or coercible to such) with dimension \eqn{1 \times n},
where \eqn{n} is the number of objective variables. Names will be
preserved and used e.g., in the print method.}

\item{names}{an optional character vector giving the names of \eqn{x}
(column names of \eqn{L}).}

\item{x}{an R object.}

\item{...}{further arguments passed to or from other methods}

\item{object}{an R object.}
}
\value{
an object of class \code{"L_objective"} which inherits
from  \code{"Q_objective"} and \code{"objective"}.
}
\description{
A linear objective function is typically of the form \deqn{c^\top
x} where \eqn{c} is a (sparse) vector of coefficients to the
\eqn{n} objective variables \eqn{x}.
}
\author{
Stefan Theussl
}
