\name{L_constraint}
\alias{L_constraint}
\title{Linear Constraints}
\usage{L_constraint(L, dir, rhs)
}
\description{Linear constraints are typically of the form \eqn{Ax \leq
b}. \eqn{A} is a (sparse) matrix of coefficients to the objective
variables \eqn{x}. \eqn{b} is called the right hand side of the
constraints.}
\value{an object of class \code{"L_constraint"} which inherits
from \code{"constraint"}.}
\author{Stefan Theussl}
\arguments{\item{L}{a numeric vector of length \eqn{n} (a single constraint)
or a matrix of dimension \eqn{n \times m}, where \eqn{n} is the
number of objective variables and \eqn{m} is the number of
constraints. Matrices can be of class
\code{"simple_triplet_matrix"} to allow a sparse representation of
constraints.}
\item{dir}{a character vector with the directions of the
constraints. Each element must be one of \code{"<"}, \code{"<="},
\code{">"}, \code{">="}, \code{"=="} or \code{"!="}.}
\item{rhs}{a numeric vector with the right hand side of the constraints.}
}

