% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_preparation.r
\name{term_intersect}
\alias{term_intersect}
\title{Combine terms in a dtm}
\usage{
term_intersect(dtm, simmat, as_dfm = T, verbose = F, sep = " & ", par = NA)
}
\arguments{
\item{dtm}{A quanteda \link[quanteda]{dfm} or a CsparseMatrix.}

\item{simmat}{A similarity matrix in CsparseMatrix format. For instance, created with \link{term_char_sim}}

\item{as_dfm}{If True, return as quanteda dfm}

\item{verbose}{If True, report progress}

\item{sep}{The separator used for pasting the terms}

\item{par}{If TRUE, add parentheses to colnames before combining. This is mainly for internal use, as it allows
specification if OR (term_union) and AND (term_intersect) operations are combined. 
If NA, this is based on whether parenthese are present.}
}
\value{
A CsparseMatrix or quanteda dfm
}
\description{
Given a dtm and a similarity (adjacency) matrix, create a new column for each nonzero cell in the
similarity matrix. For the term combinations  (everything except the diagonal) the column names will be
pasted together with a "&" separator (read as AND)
}
