% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getSingleRel.R
\name{getSingleRel}
\alias{getSingleRel}
\title{Retrieve Relationships with Cypher Queries}
\usage{
getSingleRel(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A relationship object.
}
\description{
Deprecated. Use \code{\link{cypherToList}}. Retrieve a single relationship from the graph with a Cypher query.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")
charles = createNode(graph, "Person", name = "Charles")

createRel(alice, "WORKS_WITH", bob)
createRel(bob, "KNOWS", charles, since = 2000, through = "Work")

query = "MATCH (:Person {name:'Alice'})-[r:WORKS_WITH]->(:Person {name:'Bob'})
         RETURN r"

getSingleRel(graph, query)

query = "MATCH (:Person {name:{start}})-[r:KNOWS]->(:Person {name:{end}})
         RETURN r"

getSingleRel(graph, query, start = "Bob", end = "Charles")
}
}
\seealso{
\code{\link{getRels}}
}

