/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceCommand {
    final String _input;
    final String _map;
    final String _reduce;
    final String _outputTarget;
    ReadPreference _readPref;
    String _outputDB = null;
    final OutputType _outputType;
    final DBObject _query;
    String _finalize;
    DBObject _sort;
    int _limit;
    Map<String, Object> _scope;
    Boolean _verbose = true;
    DBObject _extra;

    public MapReduceCommand(DBCollection inputCollection, String map2, String reduce2, String outputCollection, OutputType type, DBObject query) {
        this._input = inputCollection.getName();
        this._map = map2;
        this._reduce = reduce2;
        this._outputTarget = outputCollection;
        this._outputType = type;
        this._query = query;
    }

    public void setVerbose(Boolean verbose) {
        this._verbose = verbose;
    }

    public Boolean isVerbose() {
        return this._verbose;
    }

    public String getInput() {
        return this._input;
    }

    public String getMap() {
        return this._map;
    }

    public String getReduce() {
        return this._reduce;
    }

    public String getOutputTarget() {
        return this._outputTarget;
    }

    public OutputType getOutputType() {
        return this._outputType;
    }

    public String getFinalize() {
        return this._finalize;
    }

    public void setFinalize(String finalize) {
        this._finalize = finalize;
    }

    public DBObject getQuery() {
        return this._query;
    }

    public DBObject getSort() {
        return this._sort;
    }

    public void setSort(DBObject sort2) {
        this._sort = sort2;
    }

    public int getLimit() {
        return this._limit;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public Map<String, Object> getScope() {
        return this._scope;
    }

    public void setScope(Map<String, Object> scope) {
        this._scope = scope;
    }

    public void setOutputDB(String outputDB) {
        this._outputDB = outputDB;
    }

    public DBObject toDBObject() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("mapreduce", (Object)this._input);
        cmd.put("map", (Object)this._map);
        cmd.put("reduce", (Object)this._reduce);
        cmd.put("verbose", (Object)this._verbose);
        BasicDBObject out = new BasicDBObject();
        switch (this._outputType) {
            case INLINE: {
                out.put("inline", (Object)1);
                break;
            }
            case REPLACE: {
                out.put("replace", (Object)this._outputTarget);
                break;
            }
            case MERGE: {
                out.put("merge", (Object)this._outputTarget);
                break;
            }
            case REDUCE: {
                out.put("reduce", (Object)this._outputTarget);
            }
        }
        if (this._outputDB != null) {
            out.put("db", (Object)this._outputDB);
        }
        cmd.put("out", (Object)out);
        if (this._query != null) {
            cmd.put("query", (Object)this._query);
        }
        if (this._finalize != null) {
            cmd.put("finalize", (Object)this._finalize);
        }
        if (this._sort != null) {
            cmd.put("sort", (Object)this._sort);
        }
        if (this._limit > 0) {
            cmd.put("limit", (Object)this._limit);
        }
        if (this._scope != null) {
            cmd.put("scope", (Object)this._scope);
        }
        if (this._extra != null) {
            cmd.putAll(this._extra);
        }
        return cmd;
    }

    public void addExtraOption(String name, Object value) {
        if (this._extra == null) {
            this._extra = new BasicDBObject();
        }
        this._extra.put(name, value);
    }

    public DBObject getExtraOptions() {
        return this._extra;
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }

    public String toString() {
        return this.toDBObject().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        REPLACE,
        MERGE,
        REDUCE,
        INLINE;

    }
}

