% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\docType{methods}
\name{dbFetch,MariaDBResult-method}
\alias{dbFetch,MariaDBResult-method}
\alias{dbSendQuery,MariaDBConnection,character-method}
\alias{dbSendStatement,MariaDBConnection,character-method}
\alias{dbBind,MariaDBResult-method}
\alias{dbClearResult,MariaDBResult-method}
\alias{dbGetStatement,MariaDBResult-method}
\title{Execute a SQL statement on a database connection.}
\usage{
\S4method{dbFetch}{MariaDBResult}(res, n = -1, ..., row.names = FALSE)

\S4method{dbSendQuery}{MariaDBConnection,character}(conn, statement,
  params = NULL, ...)

\S4method{dbSendStatement}{MariaDBConnection,character}(conn, statement,
  params = NULL, ...)

\S4method{dbBind}{MariaDBResult}(res, params, ...)

\S4method{dbClearResult}{MariaDBResult}(res, ...)

\S4method{dbGetStatement}{MariaDBResult}(res, ...)
}
\arguments{
\item{res}{A  \linkS4class{MariaDBResult} object.}

\item{n}{Number of rows to retrieve. Use -1 to retrieve all rows.}

\item{...}{Unused. Needed for compatibility with generic.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{conn}{an \linkS4class{MariaDBConnection} object.}

\item{statement}{a character vector of length one specifying the SQL
statement that should be executed.  Only a single SQL statement should be
provided.}

\item{params}{A list of query parameters to be substituted into
a parameterised query.}
}
\description{
To retrieve results a chunk at a time, use \code{\link[=dbSendQuery]{dbSendQuery()}},
\code{\link[=dbFetch]{dbFetch()}}, then \code{\link[=dbClearResult]{dbClearResult()}}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{\link[=dbGetQuery]{dbGetQuery()}} which sends,
fetches and clears for you. For data manipulation queries (i.e. queries
that do not return data, such as \code{UPDATE}, \code{DELETE}, etc.),
\code{\link[=dbSendStatement]{dbSendStatement()}} serves as a counterpart to \code{\link[=dbSendQuery]{dbSendQuery()}}, while
\code{\link[=dbExecute]{dbExecute()}} corresponds to \code{\link[=dbGetQuery]{dbGetQuery()}}.
}
\examples{
if (mariadbHasDefault()) {
con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
dbWriteTable(con, "arrests", datasets::USArrests, temporary = TRUE)

# Run query to get results as dataframe
dbGetQuery(con, "SELECT * FROM arrests limit 3")

# Send query to pull requests in batches
res <- dbSendQuery(con, "SELECT * FROM arrests")
data <- dbFetch(res, n = 2)
data
dbHasCompleted(res)

dbClearResult(res)
dbDisconnect(con)
}
}
