% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_merge}
\alias{mvl_merge}
\title{Merge two MVL data frames and write the result}
\usage{
mvl_merge(
  MVLHANDLE,
  df1,
  df2,
  name = NULL,
  by = NULL,
  by.x = by,
  by.y = by,
  suffixes = c(".x", ".y"),
  only.columns.x = NULL,
  only.columns.y = NULL
)
}
\arguments{
\item{MVLHANDLE}{a handle to MVL file produced by \code{mvl_open()}}

\item{df1}{a data.frame stored in MVL file}

\item{df2}{a data.frame stored in MVL file}

\item{name}{if specified add a named entry to MVL file directory}

\item{by}{list of columns to use as key}

\item{by.x}{list of columns to use as key for \code{df1}}

\item{by.y}{list of columns to use as key for \code{df1}}

\item{suffixes}{rename columns with identical names using these suffixes}

\item{only.columns.x}{only copy these columns from df1}

\item{only.columns.y}{only copy these columns from df2}
}
\value{
an object of class MVL_OFFSET that describes an offset into this MVL file. MVL offsets are vectors and can be concatenated. They can be written to MVL file directly, or as part of another object such as list.
}
\description{
Merge two MVL data frames and write the result
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=rep(c("a", "b"), 50), y=1:100), "df1")
mvl_write_object(Mtmp, data.frame(x=rep(c("b", "c"), 50), y=runif(100), z=21:120), "df2")
Mtmp<-mvl_remap(Mtmp)
mvl_merge(Mtmp, Mtmp$df1, Mtmp$df2, by.x="y", by.y="z", only.columns.y=c("x"), name="df_merged")
Mtmp<-mvl_remap(Mtmp)
print(Mtmp$df_merged[1:10,])
}
}
\seealso{
\code{\link{mvl_hash_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_group}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_indexed_copy}}, \code{\link{mvl_order_vectors}}, \code{\link{mvl_fused_write_objects}}
}
