% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_group}
\alias{mvl_group}
\title{Group identical rows}
\usage{
mvl_group(L, indices = NULL)
}
\arguments{
\item{L}{list of vector like MVL_OBJECTs}

\item{indices}{list of indices into objects to group. If absent or NULL it is assumed to be from 1 to the length of the object.}
}
\value{
A list of groups and group stretches
}
\description{
This function groups identical rows. The result is formatted as two vectors \code{stretch_index} and \code{index}
Vector \code{index} contains stretches of indices with identical rows. Vector \code{stretch_index} describes stretches as stretch_index[i] to stretch_index[i+1]-1
This allows fast iteration over indices without creating excessive numbers of R objects when group sizes are small.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=rep(c("a", "b"), 50), y=(1:100)/5), "df1")
Mtmp<-mvl_remap(Mtmp)
df1<-Mtmp["df1", ref=TRUE]
G<-mvl_group(list(df1[,"x",ref=TRUE], df1[,"y", ref=TRUE]))
mvl_group_lapply(G, function(idx) { return(sum(df1[idx, "y"]))})
}
}
\seealso{
\code{\link{mvl_hash_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_order_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_indexed_copy}}, \code{\link{mvl_merge}}
}
