% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create_simulated_data.R
\name{Create_simulated_data}
\alias{Create_simulated_data}
\title{Create an example dataset for testing the MTL algorithm}
\usage{
Create_simulated_data(
  t = 5,
  p = 50,
  n = 20,
  type = "Regression",
  Regularization = "L21"
)
}
\arguments{
\item{t}{Number of tasks}

\item{p}{Number of features}

\item{n}{Number of samples of each task. For simplicity, all tasks
contain the same number of samples.}

\item{type}{The type of problem, must be "Regression" or
"Classification"}

\item{Regularization}{The type of MTL algorithm (cross-task regularizer). The value must be
one of \{\code{L21}, \code{Lasso}, \code{Trace}, \code{Graph}, \code{CMTL} \}}
}
\value{
The example dataset.
}
\description{
Create an example dataset which contains 1), training datasets (X: feature matrices, Y: response vectors); 2), test datasets 
(tX: feature matrices, tY: response vectors); 3), the ground truth model (W: coefficient matrix) and 4), extra
information for some algorithms (i.e. a matrix for encoding the network information is necessary for calling the MTL method with network 
structure(\code{Regularization=Graph} )
}
\examples{
data<-Create_simulated_data(t=5,p=50, n=20, type="Regression", Regularization="L21")
str(data)
}
