% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{geom_freq_by_year_ci}
\alias{geom_freq_by_year_ci}
\title{Experimental: Plot frequency by year graphs with confidence intervals}
\usage{
geom_freq_by_year_ci(mapping = aes(ymin = conf.low, ymax = conf.high), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by aes() or aes_(). If specified and inherit.aes = TRUE (the default), it is combined with the default mapping at the top level of the plot. You must supply mapping if there is no plot mapping.}

\item{...}{Other arguments passed to geom_ribbon, geom_line, and geom_click_point.}
}
\description{
Experimental convenience function for plotting typical frequency by year graphs with confidence intervals using ggplot2.
\bold{Warning:} This function may be moved to a new package.
}
\examples{
library(ggplot2)
kco <- new("KorAPConnection", verbose=TRUE)
\donttest{
expand_grid(condition = c("textDomain = /Wirtschaft.*/", "textDomain != /Wirtschaft.*/"),
            year = (2005:2011)) \%>\%
  cbind(frequencyQuery(kco, "[tt/l=Heuschrecke]",
                            paste0(.$condition," & pubDate in ", .$year)))  \%>\%
  ipm() \%>\%
  ggplot(aes(year, ipm, fill = condition, color = condition)) +
  geom_freq_by_year_ci()
}
}
