/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.IRIRelativize;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class TestCreator
extends DefaultHandler
implements IRIRelativize {
    static final Class[] attSign;
    static final Class[] nullSign;
    static PrintWriter out;
    static String[] methods;
    private static IRIFactory factory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.xml.sax.Attributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        attSign = classArray;
        nullSign = new Class[0];
        methods = new String[]{"getHost", "getPath", "getPort", "getQuery", "getScheme", "getUserinfo", "getFragment", "isAbsolute", "isOpaque", "isRelative", "toASCIIString"};
        factory = new IRIFactory();
    }

    TestCreator() {
    }

    public static String substituteStandardEntities(String s) {
        s = TestCreator.replace(s, "&", "&amp;");
        s = TestCreator.replace(s, "<", "&lt;");
        s = TestCreator.replace(s, ">", "&gt;");
        s = TestCreator.replace(s, "'", "&apos;");
        s = TestCreator.replace(s, "\t", "&#9;");
        s = TestCreator.replace(s, "\n", "&#xA;");
        s = TestCreator.replace(s, "\r", "&#xD;");
        return TestCreator.replace(s, "\"", "&quot;");
    }

    public static String replace(String s, String oldString, String newString) {
        String result = "";
        int length = oldString.length();
        int pos = s.indexOf(oldString);
        int lastPos = 0;
        while (pos >= 0) {
            result = String.valueOf(result) + s.substring(lastPos, pos) + newString;
            lastPos = pos + length;
            pos = s.indexOf(oldString, lastPos);
        }
        return String.valueOf(result) + s.substring(lastPos, s.length());
    }

    static void load() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("src/com/hp/hpl/jena/iri/test/test.xml"), "utf-8"));
        out.println("<UriTests>");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.hp.hpl.jena.iri.test.TestCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream in = clazz.getClassLoader().getResourceAsStream("com/hp/hpl/jena/iri/test/uris.xml");
        fact.newSAXParser().parse(in, (DefaultHandler)new TestCreator());
        out.println("</UriTests>");
        in.close();
        out.close();
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        try {
            TestCreator.load();
        }
        catch (SAXParseException e) {
            System.err.println(e.getLineNumber());
            System.err.println(e.toString());
            System.err.println(e.getMessage());
        }
    }

    public void startElement(String arg1, String arg2, String name, Attributes att) {
        try {
            this.getClass().getDeclaredMethod(name, attSign).invoke((Object)this, att);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void endElement(String arg1, String arg2, String name) {
    }

    private void uris(Attributes att) {
    }

    private void uri(Attributes att) {
        String absolute = att.getValue("absolute");
        String base = att.getValue("base");
        String relative = att.getValue("relative");
        this.doIt(absolute);
        if (base != null) {
            out.println("<Resolve>");
            IRI b = this.doIt(base);
            IRI r = this.doIt(relative);
            out.println("<Result>");
            IRI result = b.create(r);
            this.doIt(result);
            out.println("</Result>");
            IRI rAgain = b.relativize(result, 63);
            if (r.equals(rAgain)) {
                out.println("<Relativize same='true'/>");
            } else {
                out.println("<Relativize>");
                this.doIt(rAgain);
                out.println("</Relativize>");
            }
            out.println("</Resolve>");
        }
    }

    private void doIt(IRI iri) {
        if (iri == null) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            String m = methods[i];
            try {
                Object r;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.hp.hpl.jena.iri.IRI");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((r = clazz.getDeclaredMethod(m, nullSign).invoke((Object)iri, new Object[0])) == null) {
                    out.println("<" + m + " nullValue='true'/>");
                } else {
                    out.println("<" + m + " value='" + TestCreator.substituteStandardEntities(r.toString()) + "'/>");
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e;
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                String s = t.getMessage() != null ? t.getMessage() : t.toString();
                out.println("<" + m + " exception='" + TestCreator.substituteStandardEntities(s) + "'/>");
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Iterator it = ((AbsIRIImpl)iri).allViolations();
        out.println("<exceptions>");
        while (it.hasNext()) {
            out.print("<exception>");
            out.print(((Violation)it.next()).codeName());
            out.println("</exception>");
        }
        out.println("</exceptions>");
    }

    private IRI doIt(String iri) {
        if (iri == null) {
            return null;
        }
        IRI rslt = factory.create(iri);
        out.println("<IRI iri='" + TestCreator.substituteStandardEntities(iri) + "'>");
        this.doIt(rslt);
        out.println("</IRI>");
        return rslt;
    }
}

