/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class Wavelet
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    static final long serialVersionUID = -3335106965521265631L;
    public static final int ALGORITHM_HAAR = 0;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(0, "Haar")};
    public static final int PADDING_ZERO = 0;
    public static final Tag[] TAGS_PADDING = new Tag[]{new Tag(0, "Zero")};
    protected Filter m_Filter = new MultiFilter();
    protected int m_Algorithm = 0;
    protected int m_Padding = 0;

    public Wavelet() {
        ((MultiFilter)this.m_Filter).setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
    }

    public String globalInfo() {
        return "A filter for wavelet transformation.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Discrete wavelet transform");
        technicalInformation.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Discrete_wavelet_transform");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MISC);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Kristian Sandberg");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "The Haar wavelet transform");
        technicalInformation2.setValue(TechnicalInformation.Field.INSTITUTION, "Dept. of Applied Mathematics");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "University of Colorado at Boulder, USA");
        technicalInformation2.setValue(TechnicalInformation.Field.HTTP, "http://amath.colorado.edu/courses/5720/2000Spr/Labs/Haar/haar.html");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        SelectedTag selectedTag;
        int n;
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String string = "";
        for (n = 0; n < TAGS_ALGORITHM.length; ++n) {
            if (n > 0) {
                string = string + "|";
            }
            selectedTag = new SelectedTag(TAGS_ALGORITHM[n].getID(), TAGS_ALGORITHM);
            string = string + selectedTag.getSelectedTag().getReadable();
        }
        vector.addElement(new Option("\tThe algorithm to use.\n\t(default: HAAR)", "A", 1, "-A <" + string + ">"));
        string = "";
        for (n = 0; n < TAGS_PADDING.length; ++n) {
            if (n > 0) {
                string = string + "|";
            }
            selectedTag = new SelectedTag(TAGS_PADDING[n].getID(), TAGS_PADDING);
            string = string + selectedTag.getSelectedTag().getReadable();
        }
        vector.addElement(new Option("\tThe padding to use.\n\t(default: ZERO)", "P", 1, "-P <" + string + ">"));
        vector.addElement(new Option("\tThe filter to use as preprocessing step (classname and options).\n\t(default: MultiFilter with ReplaceMissingValues and Normalize)", "F", 1, "-F <filter specification>"));
        if (this.getFilter() instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-F'):"));
            enumeration = ((OptionHandler)((Object)this.getFilter())).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-A");
        vector.add("" + this.getAlgorithm().getSelectedTag().getReadable());
        vector.add("-P");
        vector.add("" + this.getPadding().getSelectedTag().getReadable());
        vector.add("-F");
        if (this.getFilter() instanceof OptionHandler) {
            vector.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        } else {
            vector.add(this.getFilter().getClass().getName());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("A", stringArray);
        if (string.length() != 0) {
            this.setAlgorithm(new SelectedTag(string, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        }
        string = Utils.getOption("P", stringArray);
        if (string.length() != 0) {
            this.setPadding(new SelectedTag(string, TAGS_PADDING));
        } else {
            this.setPadding(new SelectedTag(0, TAGS_PADDING));
        }
        string = Utils.getOption("F", stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string, stringArray2));
        } else {
            MultiFilter multiFilter = new MultiFilter();
            multiFilter.setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
            this.setFilter(multiFilter);
        }
    }

    public String filterTipText() {
        return "The preprocessing filter to use.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String algorithmTipText() {
        return "Sets the type of algorithm to use.";
    }

    public void setAlgorithm(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_ALGORITHM) {
            this.m_Algorithm = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_Algorithm, TAGS_ALGORITHM);
    }

    public String paddingTipText() {
        return "Sets the type of padding to use.";
    }

    public void setPadding(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PADDING) {
            this.m_Padding = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getPadding() {
        return new SelectedTag(this.m_Padding, TAGS_PADDING);
    }

    protected static int nextPowerOf2(int n) {
        int n2 = (int)StrictMath.ceil(StrictMath.log(n) / StrictMath.log(2.0));
        n2 = StrictMath.max(2, n2);
        return (int)StrictMath.pow(2.0, n2);
    }

    protected Instances pad(Instances instances) {
        int n;
        int n2;
        int n3;
        switch (this.m_Padding) {
            case 0: {
                if (instances.classIndex() > -1) {
                    n3 = Wavelet.nextPowerOf2(instances.numAttributes() - 1) + 1 - instances.numAttributes();
                    break;
                }
                n3 = Wavelet.nextPowerOf2(instances.numAttributes()) - instances.numAttributes();
                break;
            }
            default: {
                throw new IllegalStateException("Padding " + new SelectedTag(this.m_Algorithm, TAGS_PADDING) + " not implemented!");
            }
        }
        Instances instances2 = new Instances(instances);
        String string = this.getAlgorithm().getSelectedTag().getReadable();
        if (n3 > 0) {
            boolean bl = instances.classIndex() == instances.numAttributes() - 1;
            Vector<Integer> vector = new Vector<Integer>();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = bl ? instances2.numAttributes() - 1 : instances2.numAttributes();
                instances2.insertAttributeAt(new Attribute(string + "_padding_" + (n2 + 1)), n4);
                vector.add(new Integer(n4));
            }
            int[] nArray = new int[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                nArray[n2] = (Integer)vector.get(n2);
            }
            switch (this.m_Padding) {
                case 0: {
                    for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                        for (n = 0; n < nArray.length; ++n) {
                            instances2.instance(n2).setValue(nArray[n], 0.0);
                        }
                    }
                    break;
                }
            }
        }
        instances = instances2;
        FastVector fastVector = new FastVector();
        n = 0;
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            ++n;
            if (n2 == instances.classIndex()) {
                fastVector.addElement(new Attribute(instances.attribute(n2).name()));
                continue;
            }
            fastVector.addElement(new Attribute(string + "_" + n));
        }
        instances2 = new Instances(instances.relationName(), fastVector, instances.numInstances());
        instances2.setClassIndex(instances.classIndex());
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instances2.add(new Instance(1.0, instances.instance(n2).toDoubleArray()));
        }
        return instances2;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        return this.pad(new Instances(instances, 0));
    }

    protected Instances processHAAR(Instances instances) throws Exception {
        int n;
        int n2 = instances.classIndex();
        double[] dArray = null;
        String string = "<noname>";
        if (n2 > -1) {
            dArray = instances.attributeToDoubleArray(n2);
            string = instances.classAttribute().name();
            instances.setClassIndex(-1);
            instances.deleteAttributeAt(n2);
        }
        Instances instances2 = new Instances(instances, 0);
        int n3 = (int)StrictMath.ceil(StrictMath.log(instances.numAttributes()) / StrictMath.log(2.0));
        for (n = 0; n < instances.numInstances(); ++n) {
            double[] dArray2 = instances.instance(n).toDoubleArray();
            double[] dArray3 = new double[dArray2.length];
            for (int i = n3; i > 0; --i) {
                int n4 = (int)StrictMath.pow(2.0, i - 1);
                for (int j = 0; j < n4; ++j) {
                    dArray3[j] = (dArray2[j * 2] + dArray2[j * 2 + 1]) / StrictMath.sqrt(2.0);
                    dArray3[j + n4] = (dArray2[j * 2] - dArray2[j * 2 + 1]) / StrictMath.sqrt(2.0);
                }
                System.arraycopy(dArray3, 0, dArray2, 0, dArray3.length);
            }
            instances2.add(new Instance(1.0, dArray3));
        }
        if (n2 > -1) {
            instances2.insertAttributeAt(new Attribute(string), n2);
            instances2.setClassIndex(n2);
            for (n = 0; n < dArray.length; ++n) {
                instances2.instance(n).setClassValue(dArray[n]);
            }
        }
        return instances2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.m_Filter.setInputFormat(instances);
        }
        instances = Filter.useFilter(instances, this.m_Filter);
        switch (this.m_Algorithm) {
            case 0: {
                return this.processHAAR(this.pad(instances));
            }
        }
        throw new IllegalStateException("Algorithm type '" + this.m_Algorithm + "' is not recognized!");
    }

    public static void main(String[] stringArray) {
        Wavelet.runFilter(new Wavelet(), stringArray);
    }
}

