/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.regression.Regression;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSelector
extends ModelTestBase {
    protected Model m;

    public NewRegressionSelector(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSelector.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void test9() {
        int i;
        Model m = this.getModel();
        int num = 2;
        Resource[] subject = new Resource[2];
        Property[] predicate = new Property[2];
        String suri = "http://aldabaran/test9/s";
        String puri = "http://aldabaran/test9/";
        boolean[] tvBooleans = new boolean[]{false, true};
        long[] tvLongs = new long[]{123L, 321L};
        char[] tvChars = new char[]{'@', ';'};
        double[] tvDoubles = new double[]{123.456, 456.123};
        String[] tvStrings = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] langs = new String[]{"en", "fr"};
        Literal[] tvLitObjs = new Literal[]{m.createLiteral(new Regression.LitTestObjF()), m.createLiteral(new Regression.LitTestObjF())};
        Resource[] tvResObjs = new Resource[]{m.createResource(new Regression.ResTestObjF()), m.createResource(new Regression.ResTestObjF())};
        for (i = 0; i < 2; ++i) {
            subject[i] = m.createResource(suri + i);
            predicate[i] = m.createProperty(puri + i, "p");
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                m.add(subject[i], predicate[j], tvBooleans[j]);
                m.add(subject[i], predicate[j], tvLongs[j]);
                m.add(subject[i], predicate[j], tvChars[j]);
                m.add(subject[i], predicate[j], tvDoubles[j]);
                m.add(subject[i], predicate[j], tvStrings[j]);
                m.add(subject[i], predicate[j], tvStrings[j], langs[j]);
                m.add(subject[i], predicate[j], tvLitObjs[j]);
                m.add(subject[i], predicate[j], tvResObjs[j]);
            }
        }
        StmtIterator it1 = m.listStatements(new SimpleSelector(null, null, (RDFNode)null));
        List L1 = NewRegressionSelector.iteratorToList((Iterator)it1);
        NewRegressionSelector.assertEquals((int)32, (int)L1.size());
        StmtIterator it2 = m.listStatements(new SimpleSelector(subject[0], null, (RDFNode)null));
        List L2 = NewRegressionSelector.iteratorToList((Iterator)it2);
        for (int i2 = 0; i2 < L2.size(); ++i2) {
            NewRegressionSelector.assertEquals((Object)subject[0], (Object)((Statement)L2.get(i2)).getSubject());
        }
        NewRegressionSelector.assertEquals((int)16, (int)L2.size());
        StmtIterator it3 = m.listStatements(new SimpleSelector(null, predicate[1], (RDFNode)null));
        List L3 = NewRegressionSelector.iteratorToList((Iterator)it3);
        for (int i3 = 0; i3 < L3.size(); ++i3) {
            NewRegressionSelector.assertEquals((Object)predicate[1], (Object)((Statement)L3.get(i3)).getPredicate());
        }
        NewRegressionSelector.assertEquals((int)16, (int)L3.size());
        StmtIterator it4 = m.listStatements(new SimpleSelector(null, null, tvResObjs[1]));
        List L4 = NewRegressionSelector.iteratorToList((Iterator)it4);
        for (int i4 = 0; i4 < L4.size(); ++i4) {
            NewRegressionSelector.assertEquals((Object)tvResObjs[1], (Object)((Statement)L4.get(i4)).getObject());
        }
        NewRegressionSelector.assertEquals((int)2, (int)L4.size());
        StmtIterator it5 = m.listStatements(new SimpleSelector(null, null, false));
        List L5 = NewRegressionSelector.iteratorToList((Iterator)it5);
        for (int i5 = 0; i5 < L5.size(); ++i5) {
            NewRegressionSelector.assertEquals((boolean)false, (boolean)((Statement)L5.get(i5)).getBoolean());
        }
        NewRegressionSelector.assertEquals((int)2, (int)L5.size());
        StmtIterator it6 = m.listStatements(new SimpleSelector(null, null, tvStrings[1], langs[1]));
        List L6 = NewRegressionSelector.iteratorToList((Iterator)it6);
        for (int i6 = 0; i6 < L6.size(); ++i6) {
            NewRegressionSelector.assertEquals((String)langs[1], (String)((Statement)L6.get(i6)).getLanguage());
        }
        NewRegressionSelector.assertEquals((int)2, (int)L6.size());
    }
}

