/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public class InfModelImpl
extends ModelCom
implements InfModel {
    private Model deductionsModel = null;

    public InfModelImpl(InfGraph infgraph) {
        super(infgraph);
    }

    public InfGraph getInfGraph() {
        return (InfGraph)this.getGraph();
    }

    public Model getRawModel() {
        return new ModelCom(this.getInfGraph().getRawGraph());
    }

    public Reasoner getReasoner() {
        return this.getInfGraph().getReasoner();
    }

    public void rebind() {
        this.getInfGraph().rebind();
    }

    public void prepare() {
        this.getInfGraph().prepare();
    }

    public void reset() {
        this.getInfGraph().reset();
    }

    public ValidityReport validate() {
        return this.getInfGraph().validate();
    }

    public StmtIterator listStatements(Resource subject, Property predicate, RDFNode object, Model posit) {
        ExtendedIterator iter = this.getInfGraph().find(InfModelImpl.asNode(subject), InfModelImpl.asNode(predicate), InfModelImpl.asNode(object), posit.getGraph());
        return IteratorFactory.asStmtIterator(iter, this);
    }

    public void setDerivationLogging(boolean logOn) {
        this.getInfGraph().setDerivationLogging(logOn);
    }

    public Iterator getDerivation(Statement statement) {
        return this.getInfGraph().getDerivation(statement.asTriple());
    }

    public Model getDeductionsModel() {
        Graph deductionsGraph = this.getInfGraph().getDeductionsGraph();
        if (deductionsGraph != null && (this.deductionsModel == null || this.deductionsModel.getGraph() != deductionsGraph)) {
            this.deductionsModel = new ModelCom(deductionsGraph);
        }
        return this.deductionsModel;
    }
}

