/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.mem.faster.ProcessedTriple;

public abstract class MatchOrBind {
    public static MatchOrBind createSP(final ProcessedTriple Q) {
        return new MatchOrBind(){
            protected Domain d;
            protected final QueryNode S;
            protected final QueryNode P;
            {
                this.S = Q.S;
                this.P = Q.P;
            }

            public MatchOrBind reset(Domain d) {
                this.d = d;
                return this;
            }

            public boolean matches(Triple t) {
                return this.S.matchOrBind(this.d, t.getSubject()) && this.P.matchOrBind(this.d, t.getPredicate());
            }
        };
    }

    public static MatchOrBind createPO(final ProcessedTriple Q) {
        return new MatchOrBind(){
            protected Domain d;
            protected final QueryNode P;
            protected final QueryNode O;
            {
                this.P = Q.P;
                this.O = Q.O;
            }

            public MatchOrBind reset(Domain d) {
                this.d = d;
                return this;
            }

            public boolean matches(Triple t) {
                return this.P.matchOrBind(this.d, t.getPredicate()) && this.O.matchOrBind(this.d, t.getObject());
            }
        };
    }

    public abstract boolean matches(Triple var1);

    public abstract MatchOrBind reset(Domain var1);
}

